/*
 * Created on Jun 16, 2004
 *
 * This is a simple distance-calculation algorithm that simply computes a simple distances from myself to the ball, if one is in range.
 * 
 */
package visiontable;

import java.util.Iterator;
import java.util.List;

/**
 * @author Kevin Lam
 *
 * A trivial implementation of the DistanceCalculation interface.  This algorithm simply calculates the exact
 * distance between the player and ball in the two different scenes.  If neither scene has a ball, it is a perfect match, and if
 * one scene has the ball and another doesn't, then it's a complete mis-match. 
 *
 */
public class SimpleBallDistance implements DistanceCalculation
{

	/**
	 * 
	 */
	public SimpleBallDistance()
	{
		// nothing to do
	}

	/* (non-Javadoc)
	 * @see visiontable.DistanceCalculation#distanceBetween(visiontable.VisionTable, visiontable.VisionTable)
	 */
	public float distanceBetween(Scene one, Scene two)
	{
		float dist1, dist2;
		
		// if either of the scenes has no ball, then distance is infinite
		// if both scenes have no ball, then it's a match
		if ( (one.getBallObjects().size() == 0) && (two.getBallObjects().size() == 0) )
		{
			return 0;
		}
		// one scene has a ball, and the other does not --> cannot be a match
		if ( (one.getBallObjects().size() == 0) || (two.getBallObjects().size() == 0) )
		{
			return 999;
		}

		// calculate the distance from me to the ball in object one, and two
		ObjectInfo ballOne = (ObjectInfo) one.getBallObjects().elementAt(0);
		ObjectInfo ballTwo = (ObjectInfo) two.getBallObjects().elementAt(0);
				
		// and subtract.
		
		return Math.abs(ballOne.m_distance - ballTwo.m_distance);
		
		// a more accurate implementation of this should use the cosine law to calculate the actual 
		// Cartesian distance between the two balls in the two scenes
	}

	/* (non-Javadoc)
	 * 
	 * 	 @see visiontable.DistanceCalculation#findClosest(visiontable.VisionTable, java.util.List)
	 */
	public Scene[] findClosest(Scene key, List sceneSet)
	{
		Scene[] returnedScenes = new Scene[1];
		
		Scene currentBest = null;
		float currentBestDistance = 999;
		
		// iterate through list of Scenes, keep the one with the best score on distanceBetween...
		// note that we do not consider the Actions at all, just the VisionTables within the scenes
		Iterator it = sceneSet.iterator();
		while(it.hasNext()) 
		{
					// calculate
					Scene two = (Scene) it.next();
					float dist = distanceBetween(key, two);
					if (Math.abs(dist) < Math.abs(currentBestDistance) )
					{
						currentBest = two;
						currentBestDistance = dist; 
					}
		}
		
		returnedScenes[0] = currentBest;
		return returnedScenes;
	}

	/* (non-Javadoc)
	 * @see visiontable.DistanceCalculation#setObjectWeights(float[])
	 */
	public void setObjectWeights(float[] weights)
	{
		// TODO Auto-generated method stub
		
	}

}
