//
//	File:			VisualInfo.java
//	Author:		Krzysztof Langner
//	Date:			1997/04/28

//  Modified by:  Paul Marlow, Amir Ghavam, Yoga Selvaraj
//  Course:       Software Agents
//  Date Due:     November 30, 2000 

//  Modified by:  Tarek Hassan
//  Date:         015 June 2001

//  Modified by:	Paul Marlow
//  Date:		February 22, 2004

//  Modified by:   Kevin Lam
//  Date:          June 23, 2004
//
//  incorporated multiple object vector lists
//  removed StringTokenizer global and made class serializable

// player opponent/teammate differentiation code imported from group 3
//

package sceneInfo;

import java.util.*;
import java.io.*;



public class VisualInfo implements Serializable
{
	
	private int	m_time;
	public ArrayList m_objects;
	//public StringTokenizer m_tokenizer;
	public String m_message;
	private String teamName;
	
      // Split objects into specific lists
      private ArrayList m_ball_list;
      private ArrayList m_player_list;
      private ArrayList m_teammates_list;
      private ArrayList m_opponents_list;
      private ArrayList m_unknownPlayers_list;
      private ArrayList m_flag_list;
      private ArrayList m_goal_list;
      private ArrayList m_line_list;

  	private float sceneDist = 0.0f;
	
     /*
     private BallInfo v_ballList;
     private PlayerInfo v_teammateList;
     private PlayerInfo v_opponentList;
     private PlayerInfo v_unknownPlayerList;
     private GoalInfo v_goalList;
     private FlagInfo v_flagList;
     private LineInfo v_lineList;
     
     private ObjectInfo[] v_objList;
     */
      
  	public VisualInfo () {
  		
  	}
  	
  	
  	// Constructor for 'see' information
	public VisualInfo(String info, String myTeam)
	{
		info.trim();
	 	m_message = info;
		teamName = myTeam;
		//m_tokenizer = new StringTokenizer(info,"() ", true);
            m_player_list = new ArrayList(22);
            m_teammates_list = new ArrayList(11);
            m_opponents_list = new ArrayList(11);
            m_unknownPlayers_list = new ArrayList(22);
            m_ball_list = new ArrayList(1);
            m_goal_list = new ArrayList(10);
            m_line_list = new ArrayList(20);
            m_flag_list = new ArrayList(60);
		m_objects = new ArrayList(113);
		
		/*
	     v_ballList = new BallInfo[1];
	     v_teammateList = new PlayerInfo[11];
	     v_opponentList = new PlayerInfo[11];
	     v_unknownPlayerList = new PlayerInfo[22];
	     v_goalList = new GoalInfo[10];
	     v_flagList = new FlagInfo[20];
	     v_lineList = new LineInfo[60];
	     */
		/*
		 v_ballList = null;
	     v_teammateList = null;
	     v_opponentList = null;
	     v_unknownPlayerList = null;
	     v_goalList = null;
	     v_flagList = null;
	     v_lineList = null;
		 
	     v_objList[0] = v_ballList;
	     v_objList[1] = v_teammateList;
	     v_objList[2] = v_opponentList;
	     v_objList[3] = v_unknownPlayerList;
	     v_objList[4] = v_goalList;
	     v_objList[5] = v_flagList;
	     v_objList[6] = v_lineList;
	    */
	}

  	// Constructor for 'see' information
	public VisualInfo(String info)
	{
		info.trim();
	 	m_message = info;
		//m_tokenizer = new StringTokenizer(info,"() ", true);
            m_player_list = new ArrayList(22);
            m_teammates_list = new ArrayList(11);
            m_opponents_list = new ArrayList(11);
            m_unknownPlayers_list = new ArrayList(22);
            m_ball_list = new ArrayList(1);
            m_goal_list = new ArrayList(10);
            m_line_list = new ArrayList(20);
            m_flag_list = new ArrayList(60);
		m_objects = new ArrayList(113);
		
		/*
	     v_ballList = new BallInfo[1];
	     v_teammateList = new PlayerInfo[11];
	     v_opponentList = new PlayerInfo[11];
	     v_unknownPlayerList = new PlayerInfo[22];
	     v_goalList = new GoalInfo[10];
	     v_flagList = new FlagInfo[20];
	     v_lineList = new LineInfo[60];
	     
	     v_objList[0] = v_ballList;
	     v_objList[1] = v_teammateList;
	     v_objList[2] = v_opponentList;
	     v_objList[3] = v_unknownPlayerList;
	     v_objList[4] = v_goalList;
	     v_objList[5] = v_flagList;
	     v_objList[6] = v_lineList;
	     */
		/*
		 v_ballList = null;
	     v_teammateList = null;
	     v_opponentList = null;
	     v_unknownPlayerList = null;
	     v_goalList = null;
	     v_flagList = null;
	     v_lineList = null;
		 
	     v_objList[0] = v_ballList;
	     v_objList[1] = v_teammateList;
	     v_objList[2] = v_opponentList;
	     v_objList[3] = v_unknownPlayerList;
	     v_objList[4] = v_goalList;
	     v_objList[5] = v_flagList;
	     v_objList[6] = v_lineList;
	     */
	}
/*
	public void addBallInfo (BallInfo newBallInfo) {
		if (v_ballList == null) {
			v_ballList = newBallInfo;
			v_ballList.node_number = (short)1;
			v_ballList.is_blue = true;
			v_objList[0] = v_ballList;
		} else {
			v_ballList.addNextNode(newBallInfo);
		}
	}
	
	public void addTeammateInfo (PlayerInfo newPlayerInfo) {
		if (v_teammateList == null) {
			v_teammateList = newPlayerInfo;
			v_teammateList.node_number = (short)1;
			v_teammateList.is_blue = true;
			v_objList[1] = v_teammateList;
		} else {
			v_teammateList.addNextNode(newPlayerInfo);
		}
	}
	
	public void addOpponentInfo (PlayerInfo newPlayerInfo) {
		if (v_opponentList == null) {
			v_opponentList = newPlayerInfo;
			v_opponentList.node_number = (short)1;
			v_opponentList.is_blue = true;
			v_objList[2] = v_opponentList;
		} else {
			v_opponentList.addNextNode(newPlayerInfo);
		}
	}
	
	public void addUnknownPlayerInfo (PlayerInfo newPlayerInfo) {
		if (v_unknownPlayerList == null) {
			v_unknownPlayerList = newPlayerInfo;
			v_unknownPlayerList.node_number = (short)1;
			v_unknownPlayerList.is_blue = true;
			v_objList[3] = v_unknownPlayerList;
		} else {
			v_unknownPlayerList.addNextNode(newPlayerInfo);
		}
	}

	public void addGoalInfo (GoalInfo newGoalInfo) {
		if (v_goalList == null) {
			v_goalList = newGoalInfo;
			v_goalList.node_number = (short)1;
			v_goalList.is_blue = true;
			v_objList[4] = v_goalList;
		} else {
			v_goalList.addNextNode(newGoalInfo);
		}
	}
	
	public void addFlagInfo (FlagInfo newFlagInfo) {
		if (v_flagList == null) {
			v_flagList = newFlagInfo;
			v_flagList.node_number = (short)1;
			v_flagList.is_blue = true;
			v_objList[5] = v_flagList;
		} else {
			v_flagList.addNextNode(newFlagInfo);
		}
	}
	
	public void addLineInfo (LineInfo newLineInfo) {
		if (v_lineList == null) {
			v_lineList = newLineInfo;
			v_lineList.node_number = (short)1;
			v_lineList.is_blue = true;
			v_objList[6] = v_lineList;
		} else {
			v_lineList.addNextNode(newLineInfo);
		}
	}
	*/
	
	
	public int getTime()
	{
		return m_time;
	}
	
      public ArrayList getBallList()
      {
          return m_ball_list;
      }

      public ArrayList getPlayerList()
      {
          return m_player_list;
      }

      public ArrayList getTeammatesList()
      {
          return m_teammates_list;
      }

      public ArrayList getOpponentsList()
      {
          return m_opponents_list;
      }

      public ArrayList getUnknownPlayersList()
      {
          return m_unknownPlayers_list;
      }

      public ArrayList getGoalList()
      {
          return m_goal_list;
      }

      public ArrayList getLineList()
      {
          return m_line_list;
      }

      public ArrayList getFlagList()
      {
          return m_flag_list;
      }

	//---------------------------------------------------------------------------
	// This function parses visual information from the server
	public void parse()
	{
		String token = null;
		ObjectInfo objInfo;

            m_player_list.clear();
            m_teammates_list.clear();
            m_opponents_list.clear();
            m_unknownPlayers_list.clear();
            m_ball_list.clear();
            m_goal_list.clear();
            m_line_list.clear();
            m_flag_list.clear();
            
         
         //for the linked lists
            /*
   		 v_ballList = null;
	     v_teammateList = null;
	     v_opponentList = null;
	     v_unknownPlayerList = null;
	     v_goalList = null;
	     v_flagList = null;
	     v_lineList = null;
	     */
	     
		m_objects.clear();
		StringTokenizer m_tokenizer = new StringTokenizer(m_message,"() ", true);

		try
		{
			m_tokenizer.nextToken();	// '('
      		// Don't parse information if it's not 'see' information
			if( m_tokenizer.nextToken().compareTo("see") != 0 )
				return;

			m_tokenizer.nextToken();	// ' '
			m_time = Integer.parseInt( m_tokenizer.nextToken() ); // TIME
			m_tokenizer.nextToken();	// ' '
			token = m_tokenizer.nextToken();

			while(token.compareTo("(") == 0)// '('
			{
        			// Create soccer object for reference - can be player, ball, flag or line
				objInfo = createNewObject(m_tokenizer);

                        if (objInfo.getType().startsWith("player")) {
                            //m_objects.addElement(objInfo);
                        		m_objects.add(objInfo);
                        		m_player_list.add(objInfo);

						    //m_player_list.addElement(objInfo);
							try
							{
								//System.out.println("Player team: '" + ((PlayerInfo)objInfo).getTeamName() + "' My team: '" + teamName + "'");
								if ((teamName == null) || (teamName.length() == 0)) // I don't know my own team 
								{
									//m_unknownPlayers_list.addElement(objInfo);
									m_unknownPlayers_list.add(objInfo);
									//addUnknownPlayerInfo((PlayerInfo)objInfo);
								}
								else if (teamName.equals(((PlayerInfo) objInfo).getTeamName()))
								{
									// System.out.println("Adding to teammate list...");
									//m_teammates_list.addElement(objInfo);
									m_teammates_list.add(objInfo);
									//addTeammateInfo((PlayerInfo)objInfo);
								}
								else if (((PlayerInfo) objInfo).getTeamName().length() == 0)
								{
									// System.out.println("Adding to unknown list...");
									//m_unknownPlayers_list.addElement(objInfo);
									m_unknownPlayers_list.add(objInfo);
									//addUnknownPlayerInfo((PlayerInfo)objInfo);
								}
								else
								{
									// System.out.println("Adding to Opponent list...");
									//m_opponents_list.addElement(objInfo);
									m_opponents_list.add(objInfo);
									//addOpponentInfo((PlayerInfo)objInfo);
									
									if (m_opponents_list.size() >= 12)
									{
										System.out.println("ERROR!!  More than 11 opponents on the scene!!!");
									}
								}
							}
							catch (Exception e)
							{
								//System.out.println("Player parsing error.");
							}
                        } 
                        else if (objInfo.getType().startsWith("ball")) {
                            //m_objects.addElement(objInfo);
                        	m_objects.add(objInfo);
			    //m_ball_list.addElement(objInfo);
                        	m_ball_list.add(objInfo);
                        	
                        //	addBallInfo((BallInfo)objInfo);
                        }
                        else if (objInfo.getType().startsWith("goal")) {
                            //m_objects.addElement(objInfo);
                        	m_objects.add(objInfo);
			    //m_goal_list.addElement(objInfo);
                        	m_goal_list.add(objInfo);
                        	
                        //	addGoalInfo((GoalInfo)objInfo);
                        }
                        else if (objInfo.getType().startsWith("line")) {
                            //m_objects.addElement(objInfo);
                        	m_objects.add(objInfo);
			    //m_line_list.addElement(objInfo);
                        	m_line_list.add(objInfo);
                        	
                        //	addLineInfo((LineInfo)objInfo);
                        }
                        else if (objInfo.getType().startsWith("flag")) {
                            //m_objects.addElement(objInfo);
                        	m_objects.add(objInfo);
			    //m_flag_list.addElement(objInfo);
                        	m_flag_list.add(objInfo);
                        	
                        	//addFlagInfo((FlagInfo)objInfo);
                        }

				token = m_tokenizer.nextToken();
				if( token.compareTo(")") == 0 )
				{
					token = m_tokenizer.nextToken();
					if(token.compareTo(" ") == 0) token = m_tokenizer.nextToken();
					continue;
				}

				token = m_tokenizer.nextToken();
        			// Get object's approximate distance from agent - actual distance
        			// becomes more difficult to determine as the distance increases
				objInfo.m_distance = Float.valueOf(token).floatValue();
				token = m_tokenizer.nextToken();

				if( token.compareTo(")") == 0 )
				{
					token = m_tokenizer.nextToken();
					if(token.compareTo(" ") == 0) token = m_tokenizer.nextToken();
					continue;
				}

		        	// Get object direction relative to the agent
				objInfo.m_direction = Float.valueOf(m_tokenizer.nextToken()).floatValue();
				token = m_tokenizer.nextToken();

				if( token.compareTo(")") == 0 )
				{
					token = m_tokenizer.nextToken();
					if(token.compareTo(" ") == 0) token = m_tokenizer.nextToken();
					continue;
				}

        			// Get the distance change since last 'see' message
				objInfo.m_distChange = Float.valueOf(m_tokenizer.nextToken()).floatValue();
				token = m_tokenizer.nextToken();

				if( token.compareTo(")") == 0 )
				{
					token = m_tokenizer.nextToken();
					if(token.compareTo(" ") == 0) token = m_tokenizer.nextToken();
					continue;
				}

        			// Get direction change since last 'see' message
				objInfo.m_dirChange = Float.valueOf(m_tokenizer.nextToken()).floatValue();
				token = m_tokenizer.nextToken();

				if( token.compareTo(")") == 0 )
				{
					token = m_tokenizer.nextToken();
					if(token.compareTo(" ") == 0) token = m_tokenizer.nextToken();
					continue;
				}

				// Player's bodyDir parameter
		        	((PlayerInfo)(objInfo)).m_bodyDir = Float.valueOf(m_tokenizer.nextToken()).floatValue();
				token = m_tokenizer.nextToken();

				if( token.compareTo(")") == 0 )
				{
					token = m_tokenizer.nextToken();
					if(token.compareTo(" ") == 0) token = m_tokenizer.nextToken();
					continue;
				}

				// Player's headDir parameter
        			((PlayerInfo)(objInfo)).m_headDir = Float.valueOf(m_tokenizer.nextToken()).floatValue();

				token = m_tokenizer.nextToken();
				token = m_tokenizer.nextToken();
				if(token.compareTo(" ") == 0) token = m_tokenizer.nextToken();
			}
		}
		catch(Exception e)
		{
			System.out.println("Error parsing see information!");
			System.out.println(token);
			while( m_tokenizer.hasMoreTokens() )
      		{
        			token = m_tokenizer.nextToken();
        			System.out.print(token);//m_tokenizer.nextToken());
      		}
                  System.out.println(m_message);
			System.out.println("");
		}
	}

	//===========================================================================
	// Private implementations

	//---------------------------------------------------------------------------
	// This function creates new object based on the see message sent from the
	// server
	private ObjectInfo createNewObject(StringTokenizer m_tokenizer)
	{
		String token = null;
		ObjectInfo objInfo = null;

		m_tokenizer.nextToken();			// '('
		token = m_tokenizer.nextToken();
		if(token.compareTo("player") == 0 || token.compareTo("p") == 0)  // player object
		{
			String team = new String();
			int uniformNumber = 0;
                  boolean goalie = false;
			token = m_tokenizer.nextToken();	// ' '
			if(token.compareTo(" ") == 0)
			{
				team = m_tokenizer.nextToken();	// teamname
				token = m_tokenizer.nextToken();// ' '
				if(token.compareTo(" ") == 0)
        			{
		          		// uniform number
                              token = m_tokenizer.nextToken();
          				uniformNumber = Integer.parseInt(token);
                              token = m_tokenizer.nextToken();
                              if(token.compareTo(" ") == 0)
                              {
                                  // Player is a goalie?
                                  token = m_tokenizer.nextToken();
                                  if(token.compareTo("goalie") == 0)
                                  {
                                      goalie = true;
                                  }
                              }
        			}
			}
			objInfo = new PlayerInfo(team, uniformNumber, goalie);
		}
		else if(token.compareTo("goal") == 0 || token.compareTo("g") == 0) // goal object
		{
			token = m_tokenizer.nextToken();	// space
			if(token.compareTo(" ") == 0) token = m_tokenizer.nextToken();	// side
			objInfo = new GoalInfo(token.charAt(0));
			//System.out.println("found goal " + token);
		}
		else if(token.compareTo("ball") == 0 || token.compareTo("b") == 0) // ball object
		{
			objInfo = new BallInfo();
		}
		else if(token.compareTo("flag") == 0 || token.compareTo("f") == 0) // flag object
		{
			char type = ' ';
			char pos1 = ' ';
			char pos2 = ' ';
			int num = 0;
			boolean out = true;

			token = m_tokenizer.nextToken();	// space
			token = m_tokenizer.nextToken();	// p or g or [l|c|r] or [b|t]
			if(( token.compareTo("p") == 0 )||( token.compareTo("g") == 0 ))
			{
				type = token.charAt(0);
				token = m_tokenizer.nextToken();	// space
				token = m_tokenizer.nextToken();	// [l|r]
				pos1 = token.charAt(0);
				token = m_tokenizer.nextToken();	// space
				token = m_tokenizer.nextToken();	// [t|c|b]
				pos2 = token.charAt(0);
				out = false;
			}
			else if(( token.compareTo("l") == 0 )||( token.compareTo("r") == 0 ))
			{
				pos1 = token.charAt(0);
				token = m_tokenizer.nextToken();	// space
				token = m_tokenizer.nextToken();	// [t|b] or 0
				pos2 = token.charAt(0);

				if (pos2 == '0')
				{
					num=0;
					pos2=' ';
					out=true;
				}
				else
				{
					token = m_tokenizer.nextToken(); 	// space or )

					if ( token.compareTo(")") == 0 ) out=false;
					else
					{
						num = Integer.parseInt( m_tokenizer.nextToken() );
						out=true;
					}
				}
			}
			else if( token.compareTo("c") == 0 )
			{
				pos1 = token.charAt(0);
				token = m_tokenizer.nextToken();	// ) or space
				if ( token.compareTo(")") != 0)
				{
					token = m_tokenizer.nextToken();	// [t|b]
					pos2 = token.charAt(0);
				}
				out=false;
			}
			else if(( token.compareTo("b") == 0 )||( token.compareTo("t") == 0 ))
			{
				pos1 = token.charAt(0);
				token = m_tokenizer.nextToken();	// space
				token = m_tokenizer.nextToken();	// [r|l] or 0
				pos2 = token.charAt(0);

				if ( pos2 == '0')
				{
					pos2=' ';
					num=0;
				}
				else
				{
					token = m_tokenizer.nextToken();			// space
					num = Integer.parseInt(m_tokenizer.nextToken());	// number
					token = m_tokenizer.nextToken();			// )
				}
				out=true;
			}

      		String flagType = "flag";
      		if (type != ' ') flagType = flagType + " " + type;
      		if (pos1 != ' ') flagType = flagType + " " + pos1;
      		if (pos2 != ' ') flagType = flagType + " " + pos2;

      		// Implementing flags like this, allows one to specifically find a
      		// particular flag (i.e. "flag c", or "flag p l t")
			objInfo = new FlagInfo(flagType, type, pos1, pos2, num, out);
		}
		else if(token.compareTo("line") == 0 || token.compareTo("l") == 0) // line object
		{
			token = m_tokenizer.nextToken();	// space
			token = m_tokenizer.nextToken();	// [l|r|t|b]
			objInfo = new LineInfo(token.charAt(0));
		}
		else if(token.compareTo("Player") == 0 || token.compareTo("P") == 0)
		{
			objInfo = new PlayerInfo();
		}
		else if(token.compareTo("Goal") == 0 || token.compareTo("G") == 0)
		{
			objInfo = new GoalInfo();
		}
		else if(token.compareTo("Ball") == 0 || token.compareTo("B") == 0)
		{
			objInfo = new BallInfo();
		}
		else if(token.compareTo("Flag") == 0 || token.compareTo("F") == 0)
		{
			objInfo = new FlagInfo();
		}
		else if(token.compareTo("Line") == 0 || token.compareTo("L") == 0)
		{
			objInfo = new LineInfo();
		}

    		while (token.compareTo(")") != 0)
    		{
      		token = m_tokenizer.nextToken();
    		}

		return objInfo;
	}
	

	public float getSceneDist () {
		return sceneDist;
	}
	
	public void setSceneDist (float dist) {
		sceneDist = dist;
	}
}

