/*
 * Created on 29-Jul-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package sceneMatch;

import sceneMatch.bipartite_perfect_matching_v2.*;
import sceneInfo.*;
import java.util.ArrayList;
import java.util.Iterator;
import visiontable.Action;


/**
 * @author david.tudino
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class sceneMatchAlgorithm {
	
	protected Algorithm matcher = null;
	
	public sceneMatchAlgorithm () {
		matcher = new Algorithm();
	}
	
	/*
	public void resetAlgorithm () {
		matcher.resetAlgorithm();
	}
	*/
	
	public Scene findClosestScene (VisualInfoBPM newScene, ArrayList scenelib) {
		VisualInfoBPM currVision = null;
		Scene bestScene = null;
		Scene currScene = null;
		ObjectInfo[] currObjSet = null;
		ObjectInfo[] newObjSet = newScene.getObjectList();
		float bestSceneDistance = 100000000.0f; //make huge so first scene will get saved
		float currSceneDistance = 0.0f;
		
		try {
			
			//iterate through the list of scenes
			Iterator sceneIter = scenelib.iterator();
			loopForScenes:
			while (sceneIter.hasNext()) {
				//for each scene, need to loop through the object lists, calculating
				//the distance for each of them
				currScene = (Scene)sceneIter.next();
				currVision = currScene.getBPMVision();
				if (currVision == null) 
					break loopForScenes;
				currObjSet = currVision.getObjectList();
				if (currObjSet == null) break loopForScenes;
				//currObjSet = ((VisualInfoBPM)currScene.getBPMVision()).getObjectList();
				
				//reset counter
				currSceneDistance = 0.0f;
				
				//should always be 7, as there are that many obj types
				matchSceneObjects:
					for (int i = 0; i < 7; i++) {
						//check that both sets of nodes are here to compare
						//if they are not, take some action so the distance for
						//this set of object won't be 0
						if ((newObjSet[i] == null) && (currObjSet[i] == null)) {
							//ok, if they are both null, then skip
						} else {
							//handle case if the current set is null for this type
							//if null for one type and not the other, add the x value
							//of the first node in that set
							
							if (currObjSet[i] == null) {
									currSceneDistance += newObjSet[i].x;
							}

							if (newObjSet[i] == null) {
								currSceneDistance += currObjSet[i].x;
							}
						
							//if one of them is null, it will have been handled already
							//and if both have objects, will proceed
							if ((newObjSet[i] != null) && (currObjSet[i] != null)) {
								
								//need to append both lists together for each type
								MatchNode nodeSet = newScene.appendList(i,currObjSet[i]);
								
								//print out the list - TESTING
								//nodeSet.printLinkedList();
		
								//then call the algorithm and get the distance
								currSceneDistance += matcher.run_algorithm(nodeSet);
								
								//show the current distance calculation
								//System.out.println("current distance[" + i + "]: " + currSceneDistance + "\n");
								
								//check the distance with the current best distance, as soon as it get over,
								//quit looking at this scene
								if (currSceneDistance > bestSceneDistance) {
									newScene.unAppendList(i);
									break matchSceneObjects;
								}
								
								//remove the old scene linked list from the new list
								newScene.unAppendList(i);
							}
							matcher.resetAlgorithm();
						}
					}
	
				//need to check the final scene distances
				if (currSceneDistance < bestSceneDistance) {
					bestSceneDistance = currSceneDistance;
					bestScene = currScene;
					
				} 
				else {
	
				}
				
				//reset the scene lists
				newScene.resetNodeList();
				currVision.resetNodeList();
				matcher.resetAlgorithm();
				
			} //end while sceneIter.hasNext()
		
		} catch (StackOverflowError e) {
			//System.out.println("Current step: " + currentStep);
			//System.out.println("Current iteraton: " + currentIteration);
		}
		
		return bestScene;
	}
	
	
	public ArrayList findClosestSet (VisualInfoBPM newScene, ArrayList scenelib, float threshold, ArrayList sceneActions) {
		VisualInfoBPM currVision = null;
		ArrayList bestScenes = new ArrayList();
		Scene currScene = null;
		Action currAction = null;
		ObjectInfo[] currObjSet = null;
		ObjectInfo[] newObjSet = newScene.getObjectList();
		//float bestSceneDistance = 100000000.0f; //make huge so first scene will get saved
		float currSceneDistance = 0.0f;
		Action newAction = (Action)sceneActions.get(0);
		
		try {
			
			//iterate through the list of scenes, and save the ones which
			//fall within the distance threshold
			Iterator sceneIter = scenelib.iterator();
			loopForScenes:
			while (sceneIter.hasNext()) {
				//for each scene, need to loop through the object lists, calculating
				//the distance for each of them
				currScene = (Scene)sceneIter.next();
				
				//compare the first actions of these scenes.. if they are not the same, then
				//don't use this scene. just check for action type, not action direction, power, etc...
				currAction = (Action)currScene.getActions().get(0);
				if (currAction.getAction() != newAction.getAction())
					break loopForScenes;
				
				//don't use this scene if it has been used too many times
				//already... maybe use it here for matching.. commented out
				//for now
				//if (currScene.getPruneCount() > 5)
					//break loopForScenes;
				
				currVision = currScene.getBPMVision();
				if (currVision == null) 
					break loopForScenes;
				currObjSet = currVision.getObjectList();
				if (currObjSet == null) break loopForScenes;
				//currObjSet = ((VisualInfoBPM)currScene.getBPMVision()).getObjectList();
				
				//reset counter
				currSceneDistance = 0.0f;
				
				//should always be 7, as there are that many obj types
				matchSceneObjects:
					for (int i = 0; i < 7; i++) {
						//check that both sets of nodes are here to compare
						if ((newObjSet[i] != null) && (currObjSet[i] != null)) {
							
							//need to append both lists together for each type
							MatchNode nodeSet = newScene.appendList(i,currObjSet[i]);
							
							//print out the list - TESTING
							//nodeSet.printLinkedList();
	
							//then call the algorithm and get the distance
							currSceneDistance += matcher.run_algorithm(nodeSet);
							
							//show the current distance calculation
							//System.out.println("current distance[" + i + "]: " + currSceneDistance + "\n");
							
							//check the distance with the current best distance, as soon as it get over,
							//quit looking at this scene
							if (currSceneDistance > threshold) {
								newScene.unAppendList(i);
								break matchSceneObjects;
							}
							
							//remove the old scene linked list from the new list
							//keep these until the end, so we can benefit form the 
							//joined lists after if we determing that the scene
							//will be used
							newScene.unAppendList(i);
						}
						matcher.resetAlgorithm();
					}
	
				//need to check the final scene distances
				if (currSceneDistance < threshold) {
					bestScenes.add(currScene);
				} 
				
				//reset the scene lists
				newScene.resetNodeList();
				currVision.resetNodeList();
				matcher.resetAlgorithm();
				
			} //end while sceneIter.hasNext()
				
		} catch (StackOverflowError e) {
			//System.out.println("Current step: " + currentStep);
			//System.out.println("Current iteraton: " + currentIteration);
		} catch (Exception e) {
			
		}
		
		return bestScenes;
	}
	
	
	public void getSceneAvgs (VisualInfoBPM newScene, ArrayList scenelib) {
	
		VisualInfoBPM currVision = null;
		Scene currScene = null;
		ObjectInfo[] currObjSet = null;
		ObjectInfo[] newObjSet = newScene.getObjectList();
		float currSceneDistance;
		
		try {
			
		//iterate through the list of scenes
		Iterator sceneIter = scenelib.iterator();
		loopForScenes:
		while (sceneIter.hasNext()) {
			//for each scene, need to loop through the object lists, calculating
			//the distance for each of them
			currScene = (Scene)sceneIter.next();
			
			//don't use this scene if it has been used too many times
			//already... maybe use it here for matching.. commented out
			//for now
			//if (currScene.getPruneCount() > 5)
				//break loopForScenes;
			
			currVision = currScene.getBPMVision();
			if (currVision == null) 
				break loopForScenes;
			currObjSet = currVision.getObjectList();
			if (currObjSet == null) break loopForScenes;
			
			//reset counter
			currSceneDistance = 0.0f;
			
			//should always be 7, as there are that many obj types
			matchSceneObjects:
				for (int i = 0; i < 7; i++) {
					//check that both sets of nodes are here to compare
					if ((newObjSet[i] != null) && (currObjSet[i] != null)) {
						
						//need to append both lists together for each type
						MatchNode nodeSet = newScene.appendList(i,currObjSet[i]);
						
						//print out the list - TESTING
						//nodeSet.printLinkedList();

						//then call the algorithm and get the distance
						currSceneDistance = matcher.run_algorithm(nodeSet);
						
						//now that we have this set paired up, adjust the distances
						//in the prunced scene
						MatchNode temp_node;
						MatchNode addNodes = null;
						
						//reset counted vars, so wecan go through the list again
						for (temp_node = nodeSet; temp_node != null; temp_node = temp_node.next_node) {
							temp_node.counted = false;
						}
						
						//now loop through the nodes, and adjust the nodes based on where the paired 
						//node is
						for (temp_node = nodeSet; temp_node != null; temp_node = temp_node.next_node) {
							//will have to ensure that the node being tested belongs to the original set
							if ((temp_node.spouse != null) && (!temp_node.counted) && (temp_node.is_blue == nodeSet.is_blue)) {
								temp_node.counted = true;
								temp_node.spouse.counted = true;

								temp_node.x = (temp_node.x + temp_node.spouse.x)/2;
								temp_node.y = (temp_node.y + temp_node.spouse.y)/2;
								
							}
							/*
							 * i'm going to ignore this for now...  
							 if ((temp_node.spouse == null) && (!temp_node.counted) && (temp_node.is_blue != nodeSet.is_blue)) {
								//if there is an unpaired node in the new set only.. if it unpaired in the original
								//set, there is no point adding it again to the set
								temp_node.counted = true;
								if (addNodes == null) { 
									addNodes = temp_node;
								} else {
									addNodes.next_node = temp_node;
									addNodes = addNodes.next_node;
								}

							}*/
							
						}
						
						//remove the old scene linked list from the new list
						//keep these until the end, so we can benefit form the 
						//joined lists after if we determing that the scene
						//will be used
						newScene.unAppendList(i);
					}
					matcher.resetAlgorithm();
				}

			
			//reset the scene lists
			newScene.resetNodeList();
			currVision.resetNodeList();
			matcher.resetAlgorithm();
			
		} //end while sceneIter.hasNext()
		
		} catch (StackOverflowError e) {
			//System.out.println("Current step: " + currentStep);
			//System.out.println("Current iteraton: " + currentIteration);
		}
		
		//return bestScenes;
	}
	
	
	public boolean validatePruning (VisualInfoBPM prunedScene, ArrayList matchedSet, float threshold) {
		VisualInfoBPM currVision = null;
		ArrayList bestScenes = null;
		Scene currScene = null;
		ObjectInfo[] currObjSet = null;
		ObjectInfo[] newObjSet = prunedScene.getObjectList();
		//float bestSceneDistance = 100000000.0f; //make huge so first scene will get saved
		float currSceneDistance = 0.0f;
		boolean passedValidation = true;
		
		
		try {
			
			//iterate through the list of scenes, and save the ones which
			//fall within the distance threshold
			Iterator sceneIter = matchedSet.iterator();
			loopForScenes:
			while (sceneIter.hasNext()) {
				//for each scene, need to loop through the object lists, calculating
				//the distance for each of them
				currScene = (Scene)sceneIter.next();
				
				currVision = currScene.getBPMVision();
				if (currVision == null) break loopForScenes;
				
				currObjSet = currVision.getObjectList();
				if (currObjSet == null) break loopForScenes;
				//currObjSet = ((VisualInfoBPM)currScene.getBPMVision()).getObjectList();
				
				//reset counter
				currSceneDistance = 0.0f;
				
				//should always be 7, as there are that many obj types
				matchSceneObjects:
					for (int i = 0; i < 7; i++) {
						//check that both sets of nodes are here to compare
						if ((newObjSet[i] != null) && (currObjSet[i] != null)) {
							
							//need to append both lists together for each type
							MatchNode nodeSet = prunedScene.appendList(i,currObjSet[i]);

							//then call the algorithm and get the distance
							currSceneDistance += matcher.run_algorithm(nodeSet);
							
							//check the distance with the current best distance, as soon as it get over,
							//quit looking at this scene
							if (currSceneDistance > threshold) {
								prunedScene.unAppendList(i);
								break matchSceneObjects;
							}
							
							//remove the old scene linked list from the new list
							//keep these until the end, so we can benefit form the 
							//joined lists after if we determing that the scene
							//will be used
							prunedScene.unAppendList(i);
						}
						matcher.resetAlgorithm();
					}
	
				//check the final scene distnace.. if it still less than the threshold, 
				//increment the prune counter.. if it isn't, don't increment the counter
				if (currSceneDistance < threshold) {
					currScene.incPruneCount();
				} else {
					//set a flag if any of the scene didn't match under the threshold
					passedValidation = false;
				}
				
				//reset the scene lists
				prunedScene.resetNodeList();
				currVision.resetNodeList();
				matcher.resetAlgorithm();
				
			} //end while sceneIter.hasNext()
				
		} catch (StackOverflowError e) {
			//System.out.println("Current step: " + currentStep);
			//System.out.println("Current iteraton: " + currentIteration);
		} catch (Exception e) {
			
		}
		
		return passedValidation;
	}
}
