//
//	File:			Brain.java
//	Author:		Krzysztof Langner
//	Date:			1997/04/28
//
//    Modified by:	Paul Marlow
//    Modified by:  Kevin Lam (incorporation of scene recognition)
//    modifications pulled in from Group 3 for parameterizable algorithm selection

package visiontable;

import java.io.*;
import java.util.*;

import sceneInfo.BallInfo;
import sceneInfo.ObjectInfo;
import sceneInfo.Scene;
import sceneInfo.VisualInfo;
import sceneInfo.SceneLib;

class Brain extends Thread implements SensorInput
{
	
	//Vector storedScenes = null;
	ArrayList storedScenes = null;
	SceneLib sceneLib = null;
	
	int numRows = 0;
	int numCols = 0;
	
	SceneStats gameStats;
	
	
	public Brain () {
		
	}

//===========================================================================
// Here are suporting functions for implement logic
//
// These functions are implemented in the Brain subclasses, specifically for
// their specific implementation requirements.
//

//===========================================================================
// Implementation of SensorInput Interface


	//---------------------------------------------------------------------------
	// This function sends see information
	public void see(VisualInfo info)
	{
		m_memory.store(info);
	}


	//---------------------------------------------------------------------------
	// This function receives hear information from player
	public void hear(int time, int direction, String message)
	{
		//hear(time, message);
	}

	//---------------------------------------------------------------------------
	// This function receives hear information from referee
	public void hear(int time, String message)
	{	
		try
		{					 
		StringTokenizer tokenizer = new StringTokenizer(message,"() ");
		String token;

		// First is referee token and time token
		tokenizer.nextToken();	//hear
		tokenizer.nextToken();  //time
		tokenizer.nextToken();  //referee
		token = tokenizer.nextToken();

		if(token.compareTo("time_over") == 0)
		{
			m_timeOver = true;
		}
		
		}
		catch (Exception e)
		{
		}
			
	}


//===========================================================================
// Private members
	protected SendCommand				m_krislet;			// robot which is controled by this brain
	protected Memory					m_memory;				// place where all information is stored
	protected char					m_side;
	protected String					m_team;
	protected	int						m_distCal;
	protected int						m_sceneSel;
	protected int						m_numBest;
	protected float[]					m_objWeights;
	protected float[]					m_actionWeights;
	
	volatile protected boolean		m_timeOver;
}