/*
 * Created on Sep 22, 2005
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package visiontable;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import sceneInfo.BallInfo;
import sceneInfo.ObjectInfo;
import sceneInfo.Scene;
import sceneInfo.SceneLib;
import sceneInfo.VisualInfoVT;


public class BrainVT extends Brain 
{
	
	//Vector storedScenes = null;
	ArrayList storedScenes = null;
	SceneLib sceneLib = null;
	
	int numRows = 0;
	int numCols = 0;
	
	SceneStats gameStats;
	
	
	public BrainVT () {
		
	}
	
	//---------------------------------------------------------------------------
	// This constructor:
	// - stores connection to krislet
	// - starts thread for this object
	public BrainVT(SendCommand krislet, String team, char side, int number, String playMode, String scenelib, int sceneSel, 
					int distCal, int numBest, float[] objWeights, float[] actionWeights)
	{
		m_timeOver = false;
		m_krislet = krislet;
		m_memory = new Memory();
		m_team = team;
		m_side = side;
//		m_number = number;
//		m_playMode = playMode;

		m_distCal = distCal;
		m_sceneSel = sceneSel;
		m_numBest = numBest;
		m_objWeights = objWeights;
		m_actionWeights = actionWeights;

		// first put it somewhere on my side
		m_krislet.move( -Math.random()*52.5 , Math.random()*34.0 );

		// initialize scene database
		//System.out.println("Loading scene file " + scenelib);
   		loadSceneFile(scenelib);
   		
   		
   		//create a new stats object to keep track of the 
   		//number of scenes processed and time taken to process these
   		//scenes
   		gameStats = new SceneStats();
   		
   		
		start();
	}

	// for a future version maybe try to encapsulate all these into a single utility class that other clients just hook into...
	// ... an item for refactoring later
	public void loadSceneFile(String fname)
		{
			System.out.println("Loading scenes from file " + fname);
			try
			{
				if (fname.endsWith(".lib")) {
					FileInputStream fileIn = new FileInputStream(fname);
					ObjectInputStream ois = new ObjectInputStream(fileIn);

					sceneLib = (SceneLib) ois.readObject();
					numRows = 0;
					numCols = 0;

					ois.close();
					fileIn.close();
				} else {
					FileInputStream fileIn = new FileInputStream(fname);
					ObjectInputStream ois = new ObjectInputStream(fileIn);
					
					numRows = ((Integer) ois.readObject()).intValue();
					numCols = ((Integer) ois.readObject()).intValue();
					
					//storedScenes = (Vector) ois.readObject();
					storedScenes = (ArrayList) ois.readObject();
				
					ois.close();
					fileIn.close();
				}
			}
			catch (FileNotFoundException e)
			{
				e.printStackTrace();
			}
			catch (IOException e)
			{
				e.printStackTrace();
			}
			catch (ClassNotFoundException e)
			{
				e.printStackTrace();
			}
		
			System.out.println("Read " + storedScenes.size() + " scenes, table size (" + numRows + "," + numCols + ")");
		
		}
		
	//---------------------------------------------------------------------------
	// This is main brain function used to make decision
	// In each cycle we decide which command to issue based on
	// current situation.
	
	//  1. Get current scene info from memory
	//  2. Create a representative Scene and VisionTable
	//  3. Instantiate a DistanceCalculation object
	//  4. Pick out the best scene from the list
	//  5. Implement the same action that was taken from the stored scene
	//
	//	To ensure that we don't send commands to often after each cycle
	//	we waits one simulator steps. (This of course should be done better)
	public void run()
	{
		ObjectInfo object;
		
		long startTime, endTime, totalTime;
		int numScenes;

		
		DistanceCalculation distanceCalc;			// plug-and-play distance calculation object
				
		// *********************************************
		// choose scene selection algorithm, parameters
		// *********************************************
		switch(m_distCal) {
		  case 0: {
			  distanceCalc = new NearestNeighborCartesianObjects(m_numBest, m_side);
			  break;
			}
		  case 1: {
		    distanceCalc = new NearestNeighborCartesianCellObjects(m_numBest, m_side);
		    break;
		  }
		  case 2: {
		    distanceCalc = new NearestNeighborCellBallGoalDistance(m_numBest, m_side);
		    break;
		  }
		  case 3: {
			distanceCalc = new RandomDistance(m_numBest, m_side);
			break;
		  }
		  default: {
		    distanceCalc = new NearestNeighborCartesianCellObjects(m_numBest, m_side);
		    break;
		  }
		}
		// load weights
		distanceCalc.setObjectWeights(m_objWeights);

		//first put it somewhere on my side
		 m_krislet.move( -Math.random()*52.5 , Math.random()*34.0 );
	
		while( !m_timeOver )
		{
			// let's do a test first...
			VisualInfoVT stuff = (VisualInfoVT)m_memory.getInfo();
			if (stuff == null)
			{
				m_memory.waitForNewInfo();
			}
			else {
			
			
			// record start time
			startTime = System.currentTimeMillis();
				
				
			// we now have a viable VisualInfo object: now apply transformation from LogToScenes to cell-discretize it
			LogToScenesVT.parseSeeInfo(stuff, numRows, numCols);
			
			/////////////////////////////////////////////////////////////////
			//get the ball distance... only other change needed for the 
			//new scene lib to work correctly.. 
			if (stuff.getBallList() == null) {
				stuff.setSceneDist(0.0f);
			} else {
				BallInfo tmpinfo = (BallInfo)stuff.getBallList().get(0);
				stuff.setSceneDist(tmpinfo.m_distance);
			}
			/////////////////////////////////////////////////////////////////
			
			Scene thisScene = new Scene(numRows, numCols);
			thisScene.setVision(stuff);
			
			
			////////////////////////////////////////////////////////////////////
			//if we're using a sceneLib library, get the set of scenes which 
			//correspond to the initial distance of the scene  - in this case
			//it is still the distance of the ball from the player
			//return this list of scenes as the old scene library.. this will
			//minimize the amount of code required to use this scenelib, and
			//*should* hide the fact that the library is chaning from everything
			//as well..
			if (sceneLib != null) {
				storedScenes = sceneLib.getSceneList(thisScene.getSceneDistance());
			}
			////////////////////////////////////////////////////////////////////
			
			
			//return a set of closest mathcing scenes
			Scene[] bestScenes = distanceCalc.findClosest(thisScene, storedScenes);

			
			
			// record start time
			//startTime = System.currentTimeMillis();
			
			
			// result is a set of candidate scenes stored in bestScenes; now, choose the best one to imitate
			
			// *********************************************
			// choose scene selection algorithm, parameters
			// *********************************************
			Scene matched;
			
			switch(m_sceneSel) {
			  case 1: {
			    matched = SceneSelection.ChooseRandom(bestScenes, m_numBest);
			    break;
			  }
			  case 2: {
			    matched = SceneSelection.VoteWeighted(bestScenes, bestScenes.length, m_actionWeights);
			    break;
			  }
			  case 3: {
				matched = SceneSelection.VoteWeightedWithRandom(bestScenes, bestScenes.length, m_actionWeights, 20);
				break;
			  }
			  default: {	// 0
			    matched = SceneSelection.ChooseFirstValid(bestScenes);
			    break;
			  }
			}
			
			// record start time
			endTime = System.currentTimeMillis();
			System.out.println("Time taken: " + (endTime - startTime));
			System.out.println("Number of scenes processed: " + distanceCalc.getSceneCount());			
			
			//totalTime += (endTime - startTime);

			// now use the same action as the one we just matched with
			System.out.println("Best match in scene " + matched.getIdentString() + "; actions are " + matched.getActions());
			
			//record this cycles times
////////////////////////////////////////////////////////////
			//gameStats.addSceneInfo(distanceCalc.getSceneCount(), (endTime - startTime), matched.getIdentString(), bestScenes.length);


			List actions = matched.getActions();
			for (int x = 0; x < actions.size(); x++)
			{
				Action doThis = (Action) actions.get(x);
								
				if (doThis.getAction() == Action.ACTION_DASH)
				{
					m_krislet.dash(doThis.getActionPower() );
					System.out.println("Sending dash " + doThis.getActionPower());
				}
				else if (doThis.getAction() == Action.ACTION_TURN)
				{
					double turnDir = doThis.getActionDirection();
					
					/* are there any exact target matches?
					Vector possibleTargets = LogToScenes.predictTargets(thisScene, doThis, 0);
					if (possibleTargets.size() > 0)
					{
						// we're pretty sure about this
						ObjectInfo obj = (ObjectInfo) possibleTargets.elementAt(0);
						System.out.println("I think I'm supposed to aim at the " + obj.getType());
						// now, find the one WE'VE got, and aim at it instead
						//turnDir = obj.getDirection();
					}*/

					m_krislet.turn(turnDir);
					System.out.println("Sending turn " + turnDir);
				}
				else if (doThis.getAction() == Action.ACTION_TURNNECK) {
					m_krislet.turn_neck(doThis.getActionDirection());
					System.out.println("Sending turn_neck " + doThis.getActionDirection());
				}
				else if (doThis.getAction() == Action.ACTION_KICK)
				{
					//original method of getting the action direction
					double kickDir = doThis.getActionDirection();
					 
					// We know where is ball and we can kick it
					// so look for goal
					// added in from original krislet to find the goal direction
					// regardless of the direction found in the matched scene
					//if( m_side == 'l' )
					//	object = m_memory.getObject("goal r");
					//else
					//	object = m_memory.getObject("goal l");
					//
					//kickDir = object.getDirection();
					
					/* are there any exact target matches?
					Vector possibleTargets = LogToScenes.predictTargets(thisScene, doThis, 0);
					if (possibleTargets.size() > 0)
					{
						// we're pretty sure about this
						ObjectInfo obj = (ObjectInfo) possibleTargets.elementAt(0);
						System.out.println("I think I'm supposed to aim at the " + obj.getType());
						// now, find the one WE'VE got, and aim at it instead
					}
					*/

					m_krislet.kick(doThis.getActionPower(), kickDir);
					System.out.println("Sending kick " + doThis.getActionPower() + ", " + kickDir);
				}
				// catch??

			}
			}

			// sleep one step to ensure that we will not send
			// two commands in one cycle.
			try{
				Thread.sleep(2*SoccerParams.simulator_step);
			}catch(Exception e){}
		}
		
		//when leaves the run, should be the end of the game - 
		//display the stats for this game
		gameStats.calcAvgs();
		System.out.println(gameStats.getStats());
		
		return;
	}

}
