//
//	File:			Krislet.java
//	Author:		Krzysztof Langner
//	Date:			1997/04/28
//
// updated by Kevin Lam for Scene Recognition system
// further updated by student groups for feature enhancements
// cmd-line parameters merged from group 3 code
//
// changelog
//  01/25/2005: changed parameters to support weights entry

package visiontable;
import java.io.*;
import java.net.*;
import java.util.StringTokenizer;

import sceneInfo.VisualInfo;


//***************************************************************************
//
//	This is main object class
//
//***************************************************************************
class KrisletScenes implements SendCommand
{
//===========================================================================
// Initialization member functions

	//---------------------------------------------------------------------------
	// The main appllication function.
	// Command line format:
	//
	// KrisletScenes [-parameter value]
	//
	// Parameters:
	//
	//	host (default "localhost")
	//		The host name can either be a machine name, such as "java.sun.com" 
	//		or a string representing its IP address, such as "206.26.48.100."
	//
	//	port (default 6000)
	//		Port number for communication with server
	//
	//	team (default Kris)
	//		Team name. This name can not contain spaces.
	//
	//	scene
	//		filename containing scenes to load
	//	
	//	sceneSel (default 2 - VoteWeighted)
	//      ChooseFirstValid - 0
	//		ChooseRandom - 1
	//		VoteWeighted - 2
	//      VoteWeightedWithRandom - 3
	//
	//  actionWeights (default {1,1,1,..,1}
	//      (n1,n2,n3,...,nn)
	//
	//      floating point numbers, comma delimited, braces optional, NO SPACES
	//      choose weights for actions (dash, kick, etc)
	//
	//	distCal (default 1 - NearestNeighborCartesianCellObjects)
	//		NearestNeighborCartesianObjects - 0
	//		NearestNeighborCartesianCellObjects - 1
	//      NearestNeighborCellBallGoalDistance - 2 (Chris)
	//      RandomDistance - 3 (experimental control)
	//      ...any other bright ideas we come up with...
	//	
	//  objectWeights (default {1/0/0/0/0/0/0})
	//      (n1,n2,n3,n4,n5,...,nn)
	//
	//      floating point numbers, comma delimited, braces optional, NO SPACES
	//      choose weights for objects (ball, goal, opponents etc)
	//
	//	numBest (default 15)
	//		# of best scenes to return by distCal (ie. k value)
	//
	//  validate (no default)
	//      scene file to compare with in VALIDATION MODE (does not start up a RoboCup agent)
	//
	//	matchType (default vt)
	//		will specify which scene matching implementation will be loaded and used
	//		for either regular game play, or validation, if used with the -validate
	//		argument. 
	//		options are "vt" for visiontable implementation
	//		or "bpm" for the bipartite perfect matching implementation
	//
	
	public static void main(String a[])	
		throws SocketException, IOException
	{
	String	hostName = new String("");
	int			port = 6000;
	String	team = new String("Poland");
	int	sceneSel = 2;
	int	distCal = 1;
	String scenes = new String("krislet.scene");
	String objWeights = new String("{1,0,0,0,0,0,0,0}");	//default object weights = ball only
	String actionWeights = new String("{1,1,1,1,1,1,1}");		//default action weights = all equal
	float[] oWeights = {1,0,0,0,0,0,0,0};
	float[] aWeights = {1,1,1,1,1,1,1};
	int iter = 0;
	
	boolean validate = false;
	String validateFile = new String("krislet.scene");
	String matchingType = "vt";
	
	int	numBest = 15;
	
		try
		{											
			// First look for parameters
			for( int c = 0 ; c < a.length ; c += 2 )
			{
				if( a[c].compareTo("-host") == 0 )
				{
					hostName = a[c+1];
				}
				else if( a[c].compareTo("-port") == 0 )
				{
					port = Integer.parseInt(a[c+1]);
				}
				else if( a[c].compareTo("-team") == 0 )
				{
					team = a[c+1];
				}
				else if( a[c].compareTo("-scene") == 0 )
				{
					scenes = a[c+1];
				}				
				else if( a[c].compareTo("-validate") == 0 )
				{
					validate = true;
					validateFile = a[c+1];
				}
				else if( a[c].compareTo("-iterate") == 0 )
				{
					iter = Integer.parseInt(a[c+1]);
				}
				else if( a[c].compareTo("-sceneSel") == 0 )
				{
					sceneSel = Integer.parseInt(a[c+1]);
				}
				else if( a[c].compareTo("-distCal") == 0 )
				{
					distCal = Integer.parseInt(a[c+1]);
				}
				else if( a[c].compareTo("-numBest") == 0 )
				{
					numBest = Integer.parseInt(a[c+1]);
				}
				else if( a[c].compareTo("-actionWeights") == 0 )
				{
					actionWeights = new String(a[c+1]);
				}
				else if( a[c].compareTo("-objectWeights") == 0 )
				{
					objWeights = new String(a[c+1]);
				}
				else if( a[c].compareTo("-matchType") == 0 )
				{
					if ((a[c+1].compareToIgnoreCase("vt") == 0) ||
							(a[c+1].compareToIgnoreCase("bpm") == 0)) {
						matchingType = new String(a[c+1]);
					} else {
						throw new Exception();
					}
				}				
				else
				{
					throw new Exception();
				}
			}
			// now validate weights
			int counter = 0;
			StringTokenizer st = new StringTokenizer(actionWeights, "{}[]()/,");
			while (st.hasMoreTokens()) {
					 aWeights[counter++] = Float.parseFloat(st.nextToken());
			}
			counter = 0;
			st = new StringTokenizer(objWeights, "{}[]()/,");
			while (st.hasMoreTokens()) {
					 oWeights[counter++] = Float.parseFloat(st.nextToken());
			}
		}
		catch(Exception e)
		{
			System.err.println("");
			System.err.println("USAGE: KrisletScenes [-parameter value]");
			System.err.println("");
			System.err.println("    Parameters        value        defaults");
			System.err.println("   --------------------------------------------------");
			System.err.println("    host              host_name    localhost");
			System.err.println("    port              port_number  6000");
			System.err.println("    team              team_name    Poland");
			System.err.println("    scene             scene_lib    krislet.scene");
			System.err.println("    sceneSel          int          2 (VoteWeighted)");
			System.err.println("    distCal           int          1 (NNCartCell)");
			System.err.println("    numBest           k_value      15");
			System.err.println("    objectWeights     (see below)  (1,0,0,0,0,0,0,0)");
			System.err.println("    actionWeights     (see below)  (1,1,1,1,1,1,1)");
			System.err.println("    validate          scene_lib    (not used)");
			System.err.println("    matchType         (see below)  vt");
			System.err.println("");
			System.err.println("object and action weights should be comma-delimited with NO SPACES");
			System.err.println("   objects: ball,goal,flag,line,allplayers,teammates,opponents,unknownplayers");
			System.err.println("   actions: none,dash,kick,turnneck,turn,catch,move");
			System.err.println("sceneSel: (0)chooseFirst/(1)chooseRandom/(2)voteWeighted/(3)vote&random");
			System.err.println("distCal: (0)NNCartesianObjects/(1)NNCartesianCellObjects/(2)NNCellBallGoal");
			System.err.println("matchType: 'vt' for visiontable matching algorithms");
			System.err.println("           'bpm' for bipartite perfect matching algorthms");
			System.err.println("");
			System.err.println("    Example:");
			System.err.println("      KrisletScenes -host www.host.com -port 6000 -team Poland");
			return;
		}

		System.out.println("Running with parameters:");
		System.out.println("host: " + hostName);
		System.out.println("port: " + port);
		System.out.println("team: " + team);
		System.out.println("scenes for training: " + scenes);
		System.out.println("sceneSel: " + sceneSelAlgos[sceneSel] + " (" + sceneSel + ")");
		System.out.println("distCal: " + distCalAlgos[distCal] + " (" + distCal + ")");
		System.out.println("numBest: " + numBest);
		System.out.println("object weights: " + writeArray(oWeights));
		System.out.println("action weights: " + writeArray(aWeights));
		
		if (validate == true)
		{
			System.out.println("Running in data validation mode against data file " + validateFile);
			if (matchingType.compareToIgnoreCase("vt") == 0) {
				ValidatorVT vd = new ValidatorVT(scenes, validateFile, sceneSel, distCal, numBest, oWeights, aWeights);
				vd.runValidation();
			} else {
				ValidatorBPM vd = new ValidatorBPM(scenes, validateFile, sceneSel, distCal, numBest, oWeights, aWeights, iter);
				vd.runValidation();
			}
			
		}
		else
		{
			KrisletScenes player;
			if (matchingType.compareToIgnoreCase("vt") == 0) {
				player = new KrisletScenesVT(InetAddress.getByName(hostName), port, team, scenes, sceneSel, distCal, numBest, oWeights, aWeights);	
			} else {
				player = new KrisletScenesBPM(InetAddress.getByName(hostName), port, team, scenes, sceneSel, distCal, numBest, oWeights, aWeights);
			}
			// enter main loop
			player.mainLoop();
		}							
	}  

	/**
	 * @param array to write
	 * @return
	 */
	private static String writeArray(float[] array)
	{
		String x = new String("[");
		for(int i = 0; i < array.length; i++)
		{
			x = x.concat(Float.toString(array[i]));
			if (i < array.length -1 ) x = x.concat(",");
		}
		
		return (x + "]");
	}

	public KrisletScenes () {
		
	}
	
	
	//---------------------------------------------------------------------------
	// This constructor opens socket for  connection with server
	public KrisletScenes(InetAddress host, int port, String team, String scenes, int sceneSel, int distCal, int numBest, float[] objWeights, float[] actionWeights) 
		throws SocketException
	{
		m_socket = new DatagramSocket();
		m_host = host;
		m_port = port;
		m_team = team;
		m_scenes = scenes;
		m_sceneSel = sceneSel;
		m_distCal = distCal;
		m_numBest = numBest;
		m_objWeights = objWeights;
		m_actionWeights = actionWeights;
	}
																 
	//---------------------------------------------------------------------------
	// This destructor closes socket to server
	public void finalize()
	{
		m_socket.close();
	}


//===========================================================================
// Protected member functions

	//---------------------------------------------------------------------------
	// This is main loop for player
	protected void mainLoop() throws IOException {
		throw new IOException();
	}
	
	/*
	protected void mainLoop() throws IOException
	{
		byte[] buffer = new byte[MSG_SIZE];
		DatagramPacket packet = new DatagramPacket(buffer, MSG_SIZE);

		// first we need to initialize connection with server
		init();

		m_socket.receive(packet);
		parseInitCommand(new String(buffer,0));
		m_port = packet.getPort();

		// Now we should be connected to the server
		// and we know side, player number and play mode
		while( m_timeOver != true )
			parseSensorInformation(receive());
	}
	*/

//===========================================================================
// Implementation of SendCommand Interface

	//---------------------------------------------------------------------------
	// This function sends move command to the server
	public void move(double x, double y)
	{
		send("(move " + Double.toString(x) + " " + Double.toString(y) + ")");
	}

	//---------------------------------------------------------------------------
	// This function sends turn command to the server
	public void turn(double moment)
	{
		send("(turn " + Double.toString(moment) + ")");
	}

	public void turn_neck(double moment)
	{
		send("(turn_neck " + Double.toString(moment) + ")");
	}

	//---------------------------------------------------------------------------
	// This function sends dash command to the server
	public void dash(double power)
	{
		send("(dash " + Double.toString(power) + ")");
	}

	//---------------------------------------------------------------------------
	// This function sends kick command to the server
	public void kick(double power, double direction)
	{
		send("(kick " + Double.toString(power) + " " + Double.toString(direction) + ")");
	}

	//---------------------------------------------------------------------------
	// This function sends say command to the server
	public void say(String message)
	{
		send("(say " + message + ")");
	}

	//---------------------------------------------------------------------------
	// This function sends chage_view command to the server
	public void changeView(String angle, String quality)
	{
		send("(change_view " + angle + " " + quality + ")");
	}

	// catch??

	//---------------------------------------------------------------------------
	// This function parses initial message from the server
	/*
	 protected void parseInitCommand(String message)	throws IOException
	{
		StringTokenizer	tokenizer = new StringTokenizer(message,"() ");
		
		// We need init token
		if( tokenizer.nextToken().compareTo("init") != 0)
		{
			throw new IOException(message);
		}

		// initialize player's brain
		m_brain = new Brain(this, m_team, tokenizer.nextToken().charAt(0), Integer.parseInt(tokenizer.nextToken()), tokenizer.nextToken(), 
											m_scenes, m_sceneSel, m_distCal, m_numBest, m_objWeights, m_actionWeights);
	}
	*/



//===========================================================================
// Here comes collection of communication function
	//---------------------------------------------------------------------------
	// This function sends initialization command to the server
	protected void init()
	{
                send("(init " + m_team + " (version 8))");
	}

	//---------------------------------------------------------------------------
	// This function parses sensor information
	/*protected void parseSensorInformation(String message)
	{
		// First check kind of information		
		if( message.charAt(1) == 's' && message.charAt(3)=='e' )
		{
			VisualInfo	info = new VisualInfo(message, m_team);
			info.parse();
			m_brain.see(info);
		}
		else if( message.charAt(1) == 'h' && message.charAt(3) == 'a')
			parseHear(message);
	}*/


	//---------------------------------------------------------------------------
	// This function parses hear information
	protected void parseHear(String message)
	{
		// get hear information
		
		StringTokenizer	tokenizer = new StringTokenizer(message,"() ");
		int	time;
		String sender;

		// skipp hear token
		tokenizer.nextToken();
		time = Integer.parseInt( tokenizer.nextToken() );
		sender = tokenizer.nextToken();
		if( sender.compareTo("referee") == 0 )
		{	
			if(tokenizer.nextToken().compareTo("time_over") == 0)
			{
				m_timeOver = true;
			}
			m_brain.hear(time, message); 
		} 
		else if( sender.compareTo("self") != 0 )
			m_brain.hear(time, Integer.parseInt(sender), message);
	}


	//---------------------------------------------------------------------------
	// This function sends via socket message to the server
	protected void send(String message)
	{
		byte[] buffer = new byte[MSG_SIZE];
		message.getBytes(0, message.length(), buffer, 0);

		DatagramPacket packet = new DatagramPacket(buffer, MSG_SIZE, m_host, m_port);

		try{
			m_socket.send(packet);
		}catch(IOException e){
			System.err.println("socket sending error " + e);
		}
	}

	//---------------------------------------------------------------------------
	// This function waits for new message from server
	protected String receive() 
	{
		byte[] buffer = new byte[MSG_SIZE];
		DatagramPacket packet = new DatagramPacket(buffer, MSG_SIZE);
		try{
			m_socket.receive(packet);
		}catch(IOException e){
			System.err.println("socket receiving error " + e);
		}
		return new String(buffer,0);
	}

				
								 
//===========================================================================
// Private members
	// class memebers
	protected DatagramSocket		m_socket;		// Socket to communicate with server
	protected	InetAddress			m_host;			// Server address
	protected int					m_port;			// server port
	protected String				m_team;			// team name
	protected String				m_scenes;	//name of scene library file
	protected SensorInput			m_brain;		// input for sensor information
	protected volatile boolean	m_timeOver = false;
	// constants
	protected static final int	MSG_SIZE = 4096;	// Size of socket buffer
	protected static final String[] sceneSelAlgos = {"ChooseFirstValid", "ChooseRandom", "VoteWeighted", "VoteWeightedWithRandom"};
	protected static final String[] distCalAlgos = {"NearestNeighborCartesianObjects", "NearestNeighborCartesianCellObjects", 
												  "NearestNeighborCellBallGoalDistance", "RandomDistance"};

	// parameters
	protected int		m_sceneSel;	// Scene Selection algo
	protected int		m_distCal;	// Distance Calculation algo 
	protected int		m_numBest;	// # of best scenes to return
	protected float[] m_objWeights;
	protected float[] m_actionWeights;

}