//
//	File:			Krislet.java
//	Author:		Krzysztof Langner
//	Date:			1997/04/28
//
// updated by Kevin Lam for Scene Recognition system
// further updated by student groups for feature enhancements
// cmd-line parameters merged from group 3 code
//
// changelog
//  01/25/2005: changed parameters to support weights entry

package visiontable;
import java.io.*;
import java.net.*;
import java.util.StringTokenizer;

import sceneInfo.VisualInfoBPM;


//***************************************************************************
//
//	This is main object class
//
//***************************************************************************
class KrisletScenesBPM extends KrisletScenes
{
//===========================================================================
// Initialization member functions

	//---------------------------------------------------------------------------
	// The main appllication function.
	// Command line format:
	//
	// KrisletScenes [-parameter value]
	//
	// Parameters:
	//
	//	host (default "localhost")
	//		The host name can either be a machine name, such as "java.sun.com" 
	//		or a string representing its IP address, such as "206.26.48.100."
	//
	//	port (default 6000)
	//		Port number for communication with server
	//
	//	team (default Kris)
	//		Team name. This name can not contain spaces.
	//
	//	scene
	//		filename containing scenes to load
	//	
	//	sceneSel (default 2 - VoteWeighted)
	//      ChooseFirstValid - 0
	//		ChooseRandom - 1
	//		VoteWeighted - 2
	//      VoteWeightedWithRandom - 3
	//
	//  actionWeights (default {1,1,1,..,1}
	//      (n1,n2,n3,...,nn)
	//
	//      floating point numbers, comma delimited, braces optional, NO SPACES
	//      choose weights for actions (dash, kick, etc)
	//
	//	distCal (default 1 - NearestNeighborCartesianCellObjects)
	//		NearestNeighborCartesianObjects - 0
	//		NearestNeighborCartesianCellObjects - 1
	//      NearestNeighborCellBallGoalDistance - 2 (Chris)
	//      RandomDistance - 3 (experimental control)
	//      ...any other bright ideas we come up with...
	//	
	//  objectWeights (default {1/0/0/0/0/0/0})
	//      (n1,n2,n3,n4,n5,...,nn)
	//
	//      floating point numbers, comma delimited, braces optional, NO SPACES
	//      choose weights for objects (ball, goal, opponents etc)
	//
	//	numBest (default 15)
	//		# of best scenes to return by distCal (ie. k value)
	//
	//  validate (no default)
	//      scene file to compare with in VALIDATION MODE (does not start up a RoboCup agent)
	//
	
	public static void main(String a[])	
		throws SocketException, IOException
	{
	String	hostName = new String("");
	int			port = 6000;
	String	team = new String("Poland");
	int	sceneSel = 2;
	int	distCal = 1;
	String scenes = new String("krislet.scene");
	String objWeights = new String("{1,0,0,0,0,0,0,0}");	//default object weights = ball only
	String actionWeights = new String("{1,1,1,1,1,1,1}");		//default action weights = all equal
	float[] oWeights = {1,0,0,0,0,0,0,0};
	float[] aWeights = {1,1,1,1,1,1,1};
	int iter = 0;
	
	boolean validate = false;
	String validateFile = new String("krislet.scene");
	
	int	numBest = 15;
	
		try
		{											
			// First look for parameters
			for( int c = 0 ; c < a.length ; c += 2 )
			{
				if( a[c].compareTo("-host") == 0 )
				{
					hostName = a[c+1];
				}
				else if( a[c].compareTo("-port") == 0 )
				{
					port = Integer.parseInt(a[c+1]);
				}
				else if( a[c].compareTo("-team") == 0 )
				{
					team = a[c+1];
				}
				else if( a[c].compareTo("-scene") == 0 )
				{
					scenes = a[c+1];
				}				
				else if( a[c].compareTo("-validate") == 0 )
				{
					validate = true;
					validateFile = a[c+1];
				}
				else if( a[c].compareTo("-iterate") == 0 )
				{
					iter = Integer.parseInt(a[c+1]);
				}
				else if( a[c].compareTo("-sceneSel") == 0 )
				{
					sceneSel = Integer.parseInt(a[c+1]);
				}
				else if( a[c].compareTo("-distCal") == 0 )
				{
					distCal = Integer.parseInt(a[c+1]);
				}
				else if( a[c].compareTo("-numBest") == 0 )
				{
					numBest = Integer.parseInt(a[c+1]);
				}
				else if( a[c].compareTo("-actionWeights") == 0 )
				{
					actionWeights = new String(a[c+1]);
				}
				else if( a[c].compareTo("-objectWeights") == 0 )
				{
					objWeights = new String(a[c+1]);
				}
				else
				{
					throw new Exception();
				}
			}
			// now validate weights
			int counter = 0;
			StringTokenizer st = new StringTokenizer(actionWeights, "{}[]()/,");
			while (st.hasMoreTokens()) {
					 aWeights[counter++] = Float.parseFloat(st.nextToken());
			}
			counter = 0;
			st = new StringTokenizer(objWeights, "{}[]()/,");
			while (st.hasMoreTokens()) {
					 oWeights[counter++] = Float.parseFloat(st.nextToken());
			}
		}
		catch(Exception e)
		{
			System.err.println("");
			System.err.println("USAGE: KrisletScenes [-parameter value]");
			System.err.println("");
			System.err.println("    Parameters        value        defaults");
			System.err.println("   --------------------------------------------------");
			System.err.println("    host              host_name    localhost");
			System.err.println("    port              port_number  6000");
			System.err.println("    team              team_name    Poland");
			System.err.println("    scene             scene_lib    krislet.scene");
			System.err.println("    sceneSel          int          2 (VoteWeighted)");
			System.err.println("    distCal           int          1 (NNCartCell)");
			System.err.println("    numBest           k_value      15");
			System.err.println("    objectWeights     (see below)  (1,0,0,0,0,0,0,0)");
			System.err.println("    actionWeights     (see below)  (1,1,1,1,1,1,1)");
			System.err.println("    validate          scene_lib    (not used)");
			System.err.println("");
			System.err.println("object and action weights should be comma-delimited with NO SPACES");
			System.err.println("   objects: ball,goal,flag,line,allplayers,teammates,opponents,unknownplayers");
			System.err.println("   actions: none,dash,kick,turnneck,turn,catch,move");
			System.err.println("sceneSel: (0)chooseFirst/(1)chooseRandom/(2)voteWeighted/(3)vote&random");
			System.err.println("distCal: (0)NNCartesianObjects/(1)NNCartesianCellObjects/(2)NNCellBallGoal");
			System.err.println("");
			System.err.println("    Example:");
			System.err.println("      KrisletScenes -host www.host.com -port 6000 -team Poland");
			return;
		}

		System.out.println("Running with parameters:");
		System.out.println("host: " + hostName);
		System.out.println("port: " + port);
		System.out.println("team: " + team);
		System.out.println("scenes for training: " + scenes);
		System.out.println("sceneSel: " + sceneSelAlgos[sceneSel] + " (" + sceneSel + ")");
		System.out.println("distCal: " + distCalAlgos[distCal] + " (" + distCal + ")");
		System.out.println("numBest: " + numBest);
		System.out.println("object weights: " + writeArray(oWeights));
		System.out.println("action weights: " + writeArray(aWeights));
		
		if (validate == true)
		{
			System.out.println("Running in data validation mode against data file " + validateFile);
			ValidatorBPM vd = new ValidatorBPM(scenes, validateFile, sceneSel, distCal, numBest, oWeights, aWeights, iter);
			vd.runValidation();
			
		}
		else
		{
			KrisletScenesBPM player = new KrisletScenesBPM(InetAddress.getByName(hostName), port, team, scenes, sceneSel, distCal, numBest, oWeights, aWeights);
			// enter main loop
			player.mainLoop();
		}							
	}  

	/**
	 * @param array to write
	 * @return
	 */
	private static String writeArray(float[] array)
	{
		String x = new String("[");
		for(int i = 0; i < array.length; i++)
		{
			x = x.concat(Float.toString(array[i]));
			if (i < array.length -1 ) x = x.concat(",");
		}
		
		return (x + "]");
	}

	//---------------------------------------------------------------------------
	// This constructor opens socket for  connection with server
	public KrisletScenesBPM(InetAddress host, int port, String team, String scenes, int sceneSel, int distCal, int numBest, float[] objWeights, float[] actionWeights) 
		throws SocketException
	{
		m_socket = new DatagramSocket();
		m_host = host;
		m_port = port;
		m_team = team;
		m_scenes = scenes;
		m_sceneSel = sceneSel;
		m_distCal = distCal;
		m_numBest = numBest;
		m_objWeights = objWeights;
		m_actionWeights = actionWeights;
	}
																 


//===========================================================================
// Protected member functions

	//---------------------------------------------------------------------------
	// This is main loop for player
	protected void mainLoop() throws IOException
	{
		byte[] buffer = new byte[MSG_SIZE];
		DatagramPacket packet = new DatagramPacket(buffer, MSG_SIZE);

		// first we need to initialize connection with server
		init();

		m_socket.receive(packet);
		parseInitCommand(new String(buffer,0));
		m_port = packet.getPort();

		// Now we should be connected to the server
		// and we know side, player number and play mode
		while( m_timeOver != true )
			parseSensorInformation(receive());
	}


//===========================================================================
// Implementation of SendCommand Interface


	//---------------------------------------------------------------------------
	// This function parses initial message from the server
	protected void parseInitCommand(String message)	throws IOException
	{
		StringTokenizer	tokenizer = new StringTokenizer(message,"() ");
		
		// We need init token
		if( tokenizer.nextToken().compareTo("init") != 0)
		{
			throw new IOException(message);
		}

		// initialize player's brain
		m_brain = new BrainBPM(this, m_team, tokenizer.nextToken().charAt(0), Integer.parseInt(tokenizer.nextToken()), tokenizer.nextToken(), 
											m_scenes, m_sceneSel, m_distCal, m_numBest, m_objWeights, m_actionWeights);
	}



//===========================================================================
// Here comes collection of communication function
//This function sends initialization command to the server

	//---------------------------------------------------------------------------
	// This function parses sensor information
	private void parseSensorInformation(String message)
	{
		//set the last variable of the contructor for false, 
		//so all the newly received scenes will be 'red' for
		//the matching algorithm!
		
		// First check kind of information		
		if( message.charAt(1) == 's' && message.charAt(3)=='e' )
		{
			VisualInfoBPM	info = new VisualInfoBPM(message, m_team, false);
			info.setNodeOffset((short)30);
			info.parse();
			m_brain.see(info);
		}
		else if( message.charAt(1) == 'h' && message.charAt(3) == 'a')
			parseHear(message);
	}

}