/*
 * Created on Sep 22, 2005
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package visiontable;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.StringTokenizer;

import sceneInfo.VisualInfoVT;

public class KrisletScenesVT extends KrisletScenes 
{


		public KrisletScenesVT () {
			
		}
		
		
		//---------------------------------------------------------------------------
		// This constructor opens socket for  connection with server
		public KrisletScenesVT(InetAddress host, int port, String team, String scenes, int sceneSel, int distCal, int numBest, float[] objWeights, float[] actionWeights) 
			throws SocketException
		{
			m_socket = new DatagramSocket();
			m_host = host;
			m_port = port;
			m_team = team;
			m_scenes = scenes;
			m_sceneSel = sceneSel;
			m_distCal = distCal;
			m_numBest = numBest;
			m_objWeights = objWeights;
			m_actionWeights = actionWeights;
		}



//	===========================================================================
//	 Protected member functions

		//---------------------------------------------------------------------------
		// This is main loop for player
		protected void mainLoop() throws IOException
		{
			byte[] buffer = new byte[MSG_SIZE];
			DatagramPacket packet = new DatagramPacket(buffer, MSG_SIZE);

			// first we need to initialize connection with server
			init();

			m_socket.receive(packet);
			parseInitCommand(new String(buffer,0));
			m_port = packet.getPort();

			// Now we should be connected to the server
			// and we know side, player number and play mode
			while( m_timeOver != true )
				parseSensorInformation(receive());
		}


//	===========================================================================
//	 Implementation of SendCommand Interface

		//---------------------------------------------------------------------------
		// This function sends move command to the server

		//---------------------------------------------------------------------------
		// This function parses sensor information
		protected void parseSensorInformation(String message)
		{
			// First check kind of information		
			if( message.charAt(1) == 's' && message.charAt(3)=='e' )
			{
				VisualInfoVT	info = new VisualInfoVT(message, m_team);
				info.parse();
				m_brain.see(info);
			}
			else if( message.charAt(1) == 'h' && message.charAt(3) == 'a')
				parseHear(message);
		}
		
		
		//---------------------------------------------------------------------------
		// This function parses initial message from the server
		protected void parseInitCommand(String message) throws IOException
		{
			StringTokenizer	tokenizer = new StringTokenizer(message,"() ");
			
			// We need init token
			if( tokenizer.nextToken().compareTo("init") != 0)
			{
				throw new IOException(message);
			}

			// initialize player's brain
			m_brain = new BrainVT(this, m_team, tokenizer.nextToken().charAt(0), Integer.parseInt(tokenizer.nextToken()), tokenizer.nextToken(), 
												m_scenes, m_sceneSel, m_distCal, m_numBest, m_objWeights, m_actionWeights);
		}

	}
