package visiontable;

import java.io.*;
import java.util.*;

import sceneInfo.*;

// Written by: Kevin Lam
// changelog	04/24/2004: initial version
// 				10/19/2004: code forked from LogToArff code
// 				11/18/2004: added multiple slicing and differentiation of team/opponent
//              11/26/2004: Deryck Velasquez changes to support team name
//				01/23/2005: Modified to remove "useless" scenes (missing either action or see info)

// This utility takes as its input a file, representing what a Robocup client saw and output, over the
// course of a game.  This program takes this file as input and generates a collection of Scene objects
// representing the observed data.  The output file is ready to be analyzed for learning.

// current workflow for data analysis:
//   capture raw data from LogServer
//   run this program to generate scene file
//   run analyzer to save only key scenes-->coming soon?
//   feed into client program/recognizer/something and see how well it works!

// this code forked from the LogToArff code because of the added complexity of translating into Scenes.
//
// note: works OK with soccer server from v5.xx and up...

public class LogToScenes
{

	//Vector scenes = new Vector();
	//ArrayList scenes = new ArrayList();
	
	//try writing to a scenelib
	//SceneLib sceneLibrary = new SceneLib();
	
	//create a seperate scene library that will be storing visualinfo
	//items as a linked list, to be used by the new algorithm
	//SceneLib sceneLib2 = new SceneLib();
	
	//float dist = 0.0f;

	// this is the main function... its role is to do the following:
	// 1.  Read the log file
	// 2.  Create a Scene object representing each time cycle, adding to it every object we see on the field
	// 3.  Call the writeScenes() function at the end to write out the data to a file
	
	//number of pruned scenes
	//int prunedScenesCount = 0;
	
	public static void main(String[] args)
	{

		//int linecount = 0;
		int numRows = 3;
		int numCols = 5;
		int bin_count = 5;
		String inFile, outFile;
		
  		LogToScenes lp;// = new LogToScenes();
		
		// look for parameters
		if (args.length < 3)
		{
			System.err.println(
				"LogToScenes - converts captured Robocup log files to Scenes");
			System.err.println("\nUsage: java LogToScenes -vt in-file out-file [rows] [cols]/ -bpm in-file out-file [bin_count]");
			System.err.println("\nRows - specifies discretization levels for distances - default 3");
			System.err.println("Cols - specifies discretization levels for left/right angles - default 5");
			System.err.println("\nbin_count - specifies the number of bins that will be used to divide the stored scenes in. The size of the bins will be 100/bin_count. The default bin_count is 5.");
			
			System.err.println("\nTwo files will be written: out-file.scene and out-file.text (human-readable)\n");
			System.err.println("\nOutput file is out-file.lib2, which contains the sorted scene library.\n");
			return;
		}
		
		inFile = args[1];
		outFile = args[2];
		
		try {
			
			
			
			if (args[0].compareToIgnoreCase("-vt") == 0) {
				numRows = Integer.parseInt(args[3]);
				numCols = Integer.parseInt(args[4]);
				
				if (numRows < 1)
				{
					System.err.println("Error: invalid row size, reverting to default");
					numRows = 3;
				}
				if (numCols < 1)
				{
					System.err.println("Error: invalid column size, reverting to default");
					numCols = 5;
				}
				
				
				
			} else { //if (args[0].compareToIgnoreCase("-bpm") == 0) {
				bin_count = Integer.parseInt(args[3]);
				
				
			}


		}
		catch (Exception e)
		{
			if (args[0].compareToIgnoreCase("-vt") == 0) {
				System.err.println("Error: unable to parse row/col size, using defaults");
				numRows = 3;
				numCols = 5;
			} else {
				System.err.println("Error: unable to parse bin count size, using default");
				bin_count = 5;
			}
			
		}		
		
		if (args[0].compareToIgnoreCase("-vt") == 0) {
			lp = new LogToScenesVT(inFile, outFile, numRows, numCols);
		} else {
			lp = new LogToScenesBPM(inFile, outFile, bin_count);	
		}
		
		//parse the log file
		lp.parseLog();			
		// now write out the scene file
		lp.writeScenes();

			
	}


	public void parseLog () {
		
	}
	
	
	void writeScenes() {

	}

}