package visiontable;

import java.io.*;
import java.util.*;

import sceneInfo.*;
import sceneMatch.sceneMatchAlgorithm;

// Written by: Kevin Lam
// changelog	04/24/2004: initial version
// 				10/19/2004: code forked from LogToArff code
// 				11/18/2004: added multiple slicing and differentiation of team/opponent
//              11/26/2004: Deryck Velasquez changes to support team name
//				01/23/2005: Modified to remove "useless" scenes (missing either action or see info)

// This utility takes as its input a file, representing what a Robocup client saw and output, over the
// course of a game.  This program takes this file as input and generates a collection of Scene objects
// representing the observed data.  The output file is ready to be analyzed for learning.

// current workflow for data analysis:
//   capture raw data from LogServer
//   run this program to generate scene file
//   run analyzer to save only key scenes-->coming soon?
//   feed into client program/recognizer/something and see how well it works!

// this code forked from the LogToArff code because of the added complexity of translating into Scenes.
//
// note: works OK with soccer server from v5.xx and up...

public class LogToScenesBPM extends LogToScenes
{
	
	//create a seperate scene library that will be storing visualinfo
	//items as a linked list, to be used by the new algorithm
	private SceneLib sceneLib2 = null;
	private SceneLib sceneLib_p = null;
	
	private float dist = 0.0f;

	private int sceneBins = 6;
	private float sceneThreshold = 500.0f;
	private int pruneCount = 2;
	private boolean pruneScenes = false;
	private int prunedScenesCount = 0;
	
	private String logFileName, sceneFileName;
	
	
	public LogToScenesBPM (String inFile, String outScene, int bin_count) {
		logFileName = inFile;
		sceneFileName = outScene;
		
		if (bin_count == 6) {
			sceneLib2 = new SceneLib();
		} else {
			sceneLib2 = new SceneLib(bin_count);
			sceneBins = bin_count;
		}
	}
	
	
	public LogToScenesBPM (int bin_count) {
		if (bin_count == 6) {
			sceneLib2 = new SceneLib();
		} else {
			sceneLib2 = new SceneLib(bin_count);
			sceneBins = bin_count;
		}
	}
	
	
	// this is the main function... its role is to do the following:
	// 1.  Read the log file
	// 2.  Create a Scene object representing each time cycle, adding to it every object we see on the field
	// 3.  Call the writeScenes() function at the end to write out the data to a file
	public void parseLog ()
	{

		int linecount = 0;
		int bin_count = 5;
		
        String my_team;

		
		StringTokenizer m_tokenizer;
				
		try
		{
			BufferedReader in = new BufferedReader(new FileReader(logFileName));
            StringBuffer test = new StringBuffer(logFileName.substring(logFileName.lastIndexOf("/")+1));
			my_team = new String(test);
			try {
				my_team = new String(test.substring(0,test.lastIndexOf("_")));		// default team name is the filename of the log
			}
			catch (Exception e)
			{
			}

			System.out.println("Using teamname " + my_team);

						
			String str;
			String mytoken;

            int currentTime = 0;					// easy integer representation of this scene's time
			
            
            Scene currentSceneBPM = new Scene();
            currentSceneBPM.setIdentString("0");
            currentSceneBPM.setTeamName(my_team);
            
            
			System.out.println("Reading log data...");
			while ((str = in.readLine()) != null)
			{
				linecount++;		// just a counter for reporting purposes
				
				// step 1: tokenize first word

				str.trim();
				m_tokenizer = new StringTokenizer(str, "() ", true);
				if (m_tokenizer.hasMoreTokens())
				{
					m_tokenizer.nextToken(); // '('
					mytoken = m_tokenizer.nextToken(); // 'sense_body', etc.

					// step 2: based on word, pass to other functions as necessary
					//         right now we really only care about "see" and "sense_body" and the player actions

					if (mytoken.equals("init"))
					{
						m_tokenizer.nextToken();	// eat up the space
							String myTeamName = "\"" + m_tokenizer.nextToken() + "\"";
                            System.out.println("My team is " + myTeamName);
                            // Added by Deryck Velasquez 11/26/04: 
                            // Store the team name of the observer.
                            currentSceneBPM.setTeamName(my_team);
                            my_team = myTeamName;
							
					}
					if (mytoken.equals("sense_body"))
					{
						SenseBodyInfo logBody = new SenseBodyInfo(str);
						
						// ok, now we know about our own velocity and stamina and stuff... 
						// store somewhere in scene? currently no provision
						// should add later...
						
						if ((int)logBody.time == currentTime)
						{
							// attach the contents of logBody to the currentScene
						}
						else		// we've got a new time point.. so we must be done with the old one
						{
							sceneLib2.placeScene(currentSceneBPM, currentSceneBPM.getSceneDistance());
							
							currentSceneBPM = new Scene();
							currentSceneBPM.setTeamName(my_team);
							currentSceneBPM.setIdentString("" + ((int)logBody.time));
							
							currentTime = (int) logBody.time;
							
						}
						
					}
					else if (mytoken.equals("see"))
					{
						VisualInfoBPM logSeeBPM = new VisualInfoBPM(str, my_team, true);
						
						logSeeBPM.parse();
						if(logSeeBPM.getTime() != 0)
						{
							if (logSeeBPM.getTime() == currentTime)
							{
								parseSeeInfoBPM(logSeeBPM);
								// now logSee contains cell row/col info			
								currentSceneBPM.setVisionBPM(logSeeBPM);	// what to do if one timepoint's data spans over two see's?
							}
							else		// we've got a new time point.. so we must be done with the old one
							{
								sceneLib2.placeScene(currentSceneBPM, currentSceneBPM.getSceneDistance());
								

								currentSceneBPM = new Scene();
								currentSceneBPM.setIdentString("" + ((int)logSeeBPM.getTime()));		// the time stamp of this scene
                                	currentSceneBPM.setTeamName(my_team);
                                
                                	currentTime = (int) logSeeBPM.getTime();
							
                                
								//System.out.println("Parsing info for timestamp " + currentTime);
                                	parseSeeInfoBPM(logSeeBPM);
								currentSceneBPM.setVisionBPM(logSeeBPM);
							}
						}
						
					}

					// actions
					// hard-coding it so that only 2 actions are stored
					else if (mytoken.equals("dash"))
					{
						Action newDash = new Action(Action.ACTION_DASH);
						m_tokenizer.nextToken(); // the ' '
						
						// also set angle, power and stuff!
						newDash.setActionPower(Float.valueOf(m_tokenizer.nextToken()).floatValue()); 
						
						m_tokenizer.nextToken(); // the ')'
							
						//if (currentScene.getActions().size() < 2)
						//{
							currentSceneBPM.addAction(newDash);
						//}
					}
					else if (mytoken.equals("turn"))
					{
						Action newTurn = new Action(Action.ACTION_TURN);
						m_tokenizer.nextToken(); // the ' '
						
						// also set angle, power and stuff!
						newTurn.setActionDirection(Float.valueOf(m_tokenizer.nextToken()).floatValue()); 
						
						m_tokenizer.nextToken(); // the ')'
							
						//if (currentScene.getActions().size() < 2)
						//{
							currentSceneBPM.addAction(newTurn);
						//}
					}
					else if (mytoken.equals("turn_neck"))
					{
						Action newTurn = new Action(Action.ACTION_TURNNECK);
						m_tokenizer.nextToken(); // the ' '
						
						// also set angle, power and stuff!
						newTurn.setActionDirection(Float.valueOf(m_tokenizer.nextToken()).floatValue()); 
						
						m_tokenizer.nextToken(); // the ')'
							
						//if (currentScene.getActions().size() < 2)
						//{
							currentSceneBPM.addAction(newTurn);
						//}
					}
					else if (mytoken.equals("kick"))
					{
						Action newKick = new Action(Action.ACTION_KICK);
						m_tokenizer.nextToken(); // the ' '
						
						// also set angle, power and stuff!
						newKick.setActionPower(Float.valueOf(m_tokenizer.nextToken()).floatValue()); 
						
						m_tokenizer.nextToken(); // the ' '
						
						newKick.setActionDirection(Float.valueOf(m_tokenizer.nextToken()).floatValue());
						 
						m_tokenizer.nextToken(); // the ')'
							
						//if (currentScene.getActions().size() < 2)
						//{
							currentSceneBPM.addAction(newKick);
						//}
					}
					else if (mytoken.equals("catch"))
					{
						//if (currentScene.getActions().size() < 2)
						//{

						currentSceneBPM.addAction(new Action(Action.ACTION_CATCH));
						// also set angle, power and stuff!
						//}
					}

					// otherwise ignore it, we don't care right now
				}
			}
			// is currentSlice = 6000 now, and not added?
			sceneLib2.placeScene(currentSceneBPM, currentSceneBPM.getSceneDistance());
			
			sceneLib2.showLibStats();
			
			in.close();
			
			// finished reading file and building objects... 

			if (pruneScenes)
				pruneScenes();
						
			System.out.println(getPrunedSceneCount() + " scenes were pruned.");
			System.out.println("Done (read " + linecount + " lines).\n");

		}
		catch (IOException e)
		{
			System.err.println("Unable to process file: \n" + e);
		}

	}
	
	
	/**
	 *  return an array of objectinfos, containing most likely target objects for action
	 */
	public static Vector predictTargets(Scene thisScene, Action thisAction, int confidence)
	{
		Vector likelyObjs = new Vector();
		
		double dir = thisAction.getActionDirection();
		
		Iterator objs = thisScene.getAllObjects().iterator();
		while (objs.hasNext())
		{
			// scan objects in the scene, look for matching directions
			ObjectInfo thisObject = (ObjectInfo) objs.next();
			double thisDir = thisObject.getDirection();
			if (Math.abs(thisDir - dir) <= confidence)
			{
				// directions are very similar, could be a match
				likelyObjs.add(thisObject);
			}
		}					
		
		return likelyObjs;
	}
	
	
	/**
	 * Will use this method to try to reduce the number of scenes in the 
	 * library by comparing them with each other. If there are scenes that
	 * closely match, one of them will be removed. The idea is to get rid of
	 * mutiple scenes that can be matched for a new target scene, thereby
	 * making the library more efficient, and opneing more room for more
	 * diverse scenes.
	 */
	private void pruneScenes()
	{
		//will need to make sure the same number of bins are used...
		SceneLib newlib = new SceneLib(sceneBins);
		Scene prunedScene;
		
		//get the algorithm
		sceneMatchAlgorithm matcher = new sceneMatchAlgorithm();
		
		int scenesPruned = 0;
		int failedCount = 0;
		boolean passedFlag = true;
		
		int badSetMatchCount = 0;
		
		int loopCount = 0;
		
		
		//will craete an array list for the matched scenes. each item
		//in the array list will be a bin of matched scenes. when complete
		//will go though each bin and get the sums for the scenes within, creating
		//a new scene for every bin
		ArrayList newScenes;//  = new ArrayList();
		
		//will loop through each of the scene bins, getting the scenes
		//and comparing them with each other
		//will keep track of the scene that it matched under the threshold 
		//with, and the distance
		for (int i = 0; i < sceneLib2.getNumBins(); i++) {
			ArrayList currBin = sceneLib2.getSceneBinByIndex(i);
			Iterator currBinIter = currBin.iterator();
			
			//System.out.println("Iterating through bin " + i);
			//System.out.println("Current bin size: " + currBin.size());
			//System.out.println("Current bin iterator.hasNext(): " + currBinIter.hasNext());
			
			
			while (currBinIter.hasNext()) {
			//for (int binCount = 0; binCount < currBin.size(); binCount++) {
				
				loopCount++;
				//System.out.println("bin: " + i + ", size: " + currBin.size() + ", loop: " + loopCount);
				
				
				//now we have the current scene
				Scene currScene = (Scene)currBinIter.next();
				//Scene currScene = (Scene)currBin.get(binCount);
				
				//don't use this scene if it has been used too many times
				//already
				if (currScene.getPruneCount() > pruneCount) {
					scenesPruned++;
					//break fetchScene;
				} else {
				
					//get the visualinfo
					VisualInfoBPM currVision = currScene.getBPMVision();
					
					//need to change the color of this scene for the algorithm
					//and make a copy of it for the new scene as well
					VisualInfoBPM newPrunedVision = new VisualInfoBPM(currVision.m_message, currScene.getTeamName(), !currVision.isBlue());
					newPrunedVision.parse();
					
					//need to compare this to all the others in this bin (currBin)
					//and get the set of matched scenes
					newScenes = matcher.findClosestSet(newPrunedVision, currBin, sceneThreshold, currScene.getActions());
					
					//System.out.println("Number of new scenes: " + newScenes.size());
					
					//check if there were any matches...
					if ((newScenes == null) || (newScenes.size() == 0)) {
						//System.out.println("newScenes was null or size = 0");
						//badSetMatchCount++;
						//break fetchScene;
						
						//wasn't matched with anything.. add it as it is
						newlib.placeScene(currScene, currScene.getSceneDistance());	
					} else {
						
						//now, we have an ArrayList of closely matched scenes
						//need to compare them, and calculate average points
						//which will be updated in newPrunedVision
						matcher.getSceneAvgs(newPrunedVision, newScenes);
						
						//test matched scenes, to see that they still fall within
						//the threshold.. 
						passedFlag = matcher.validatePruning(newPrunedVision, newScenes, sceneThreshold);
						
						if (!passedFlag)
							failedCount++;
						
						
						//now, add the matched visualinfo to a scene, and add the scene to the new
						//library
						parseSeeInfoBPM(newPrunedVision);
						
						prunedScene = new Scene();
						prunedScene.setIdentString(currScene.getIdentString());
						prunedScene.setTeamName(currScene.getTeamName());
						prunedScene.setVisionBPM(newPrunedVision);
						prunedScene.addActionList(currScene.getActions());
						
						newlib.placeScene(prunedScene, prunedScene.getSceneDistance());	
					}
				}
			}
		}

		System.out.println("\n\nCompleted Scene Pruning.\n\n");
		System.out.println("Completed with " + loopCount + " iterations");
		System.out.println("Pruned " + scenesPruned + " scenes.");
		System.out.println("Failed pruning validation on " + failedCount + " pruned scenes.");
		System.out.println("Found " + badSetMatchCount + " sets with 0 matches.");
		
		System.out.println("New Library:");
		newlib.showLibStats();
		
		sceneLib_p = newlib;
				
	}

	/**
	 * @param sceneSet
	 * @return
	 */
	private Scene createAvgScene (ArrayList sceneSet) {
		Scene newScene = new Scene();
		
		//VisualInfoBPM newVision = new VisualInfoBPM();
		
		return newScene;
	}
	

	public static void parseSeeInfoBPM(VisualInfoBPM logSee)
	{
		if (logSee.getBallInfo() == null) {
			logSee.setSceneDist(250.0f);
		} else {
			BallInfo tmpbll = logSee.getBallInfo();
			if (tmpbll.m_distance > 0.0f) {
				logSee.setSceneDist(tmpbll.m_distance);
			} else {
				logSee.setSceneDist(0.0f);
			}
			
		}
	}


	void writeScenes()
	{
		try
		{
			
			System.out.println("Writing SceneLibrary to " + sceneFileName + "BPM.lib2");
			sceneLib2.showLibStats();
			
			FileOutputStream lib2FileOut = new FileOutputStream(sceneFileName + "BPM.lib2");
			ObjectOutputStream lib2out = new ObjectOutputStream(lib2FileOut);
			lib2out.writeObject(sceneLib2);
			lib2out.close();
			lib2FileOut.close();
			
			System.out.println("Finished writign scenelib.\n\n");
			
			if (pruneScenes) {
				System.out.println("Writing SceneLibrary to " + sceneFileName + "BPM_pruned.lib2");
				sceneLib_p.showLibStats();
				
				FileOutputStream lib3FileOut = new FileOutputStream(sceneFileName + "BPM_pruned.lib2");
				ObjectOutputStream lib3out = new ObjectOutputStream(lib3FileOut);
				lib3out.writeObject(sceneLib_p);
				lib3out.close();
				lib3FileOut.close();
				
				System.out.println("Finished writing pruned scenelib.\n\n");
			}
			
		}
		catch (FileNotFoundException e)
		{

			e.printStackTrace();
		}
		catch (UnsupportedEncodingException e)
		{

			e.printStackTrace();
		}
		catch (IOException e)
		{

			e.printStackTrace();
		}
		
	
	}

	public int getPrunedSceneCount () {
		return prunedScenesCount;
	}

}