/*
 * Created on Sep 27, 2005
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package visiontable;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

import sceneInfo.BallInfo;
import sceneInfo.ObjectInfo;
import sceneInfo.Scene;
import sceneInfo.SenseBodyInfo;
import sceneInfo.VisualInfo;
import sceneInfo.VisualInfoBPM;

public class LogToScenesVT extends LogToScenes {


	//Vector scenes = new Vector();
	private ArrayList scenes = new ArrayList();
	
	//try writing to a scenelib
	//SceneLib sceneLibrary = new SceneLib();
	
	//create a seperate scene library that will be storing visualinfo
	//items as a linked list, to be used by the new algorithm
	//SceneLib sceneLib2 = new SceneLib();
	
	private float dist = 0.0f;

	// this is the main function... its role is to do the following:
	// 1.  Read the log file
	// 2.  Create a Scene object representing each time cycle, adding to it every object we see on the field
	// 3.  Call the writeScenes() function at the end to write out the data to a file
	
	private String logFileName, sceneFileName;
	private int numRows = 3;
	private int numCols = 5;
	
	//number of pruned scenes
	private int prunedScenesCount = 0;
	
	public LogToScenesVT(String inLog, String outScene, int numRow, int numCol) {
		logFileName = inLog;
		sceneFileName = outScene;
		numRows = numRow;
		numCols = numCol;
	}
	
	public void parseLog() {

		int linecount = 0;
		//int numRows = 3;
		//int numCols = 5;
        String my_team;

		StringTokenizer m_tokenizer;
		
		try
		{
			BufferedReader in = new BufferedReader(new FileReader(logFileName));
            StringBuffer test = new StringBuffer(logFileName.substring(logFileName.lastIndexOf("/")+1));
			my_team = new String(test);
			try {
				my_team = new String(test.substring(0,test.lastIndexOf("_")));		// default team name is the filename of the log
			}
			catch (Exception e)
			{
			}

			System.out.println("Using teamname " + my_team);

			System.out.println("Using table dimensions (" + numRows + ", " + numCols + ")");
						
			String str;
			String mytoken;

			Scene currentScene = new Scene(numRows, numCols);
			currentScene.setIdentString("0");		// the time stamp of this scene
			//////////////////////////////////////////
            currentScene.setTeamName(my_team);
            ////////////////////////////////////////////
            int currentTime = 0;					// easy integer representation of this scene's time
			
            
			System.out.println("Reading log data...");
			while ((str = in.readLine()) != null)
			{
				linecount++;		// just a counter for reporting purposes
				
				// step 1: tokenize first word

				str.trim();
				m_tokenizer = new StringTokenizer(str, "() ", true);
				if (m_tokenizer.hasMoreTokens())
				{
					m_tokenizer.nextToken(); // '('
					mytoken = m_tokenizer.nextToken(); // 'sense_body', etc.

					// step 2: based on word, pass to other functions as necessary
					//         right now we really only care about "see" and "sense_body" and the player actions

					if (mytoken.equals("init"))
					{
						m_tokenizer.nextToken();	// eat up the space
							String myTeamName = "\"" + m_tokenizer.nextToken() + "\"";
                            System.out.println("My team is " + myTeamName);
                            // Added by Deryck Velasquez 11/26/04: 
                            // Store the team name of the observer.
                            currentScene.setTeamName(myTeamName);
                            my_team = myTeamName;
							
					}
					if (mytoken.equals("sense_body"))
					{
						SenseBodyInfo logBody = new SenseBodyInfo(str);
						
						// ok, now we know about our own velocity and stamina and stuff... 
						// store somewhere in scene? currently no provision
						// should add later...
						
						if ((int)logBody.time == currentTime)
						{
							// attach the contents of logBody to the currentScene
						}
						else		// we've got a new time point.. so we must be done with the old one
						{
							scenes.add(currentScene);
							
							currentScene = new Scene(numRows, numCols);
//							////////////////////////////////////////
							currentScene.setTeamName(my_team);
//							//////////////////////////////////////////
							currentScene.setIdentString("" + ((int)logBody.time));		// the time stamp of this scene
							
							currentTime = (int) logBody.time;
							
						}
						
						
					}
					else if (mytoken.equals("see"))
					{
						VisualInfo logSee = new VisualInfo(str, my_team);
						
						logSee.parse();
						if(logSee.getTime() != 0)
						{
							if (logSee.getTime() == currentTime)
							{
								parseSeeInfo(logSee, numRows, numCols);				// now logSee contains cell row/col info
								currentScene.setVision(logSee);						// what to do if one timepoint's data spans over two see's?
							}
							else		// we've got a new time point.. so we must be done with the old one
							{
								scenes.add(currentScene);					
								
								currentScene = new Scene(numRows, numCols);
								currentScene.setIdentString("" + ((int)logSee.getTime()));		// the time stamp of this scene
								////////////////////////////////////////////
                                	currentScene.setTeamName(my_team);
                                	////////////////////////////////////////////
                                
                                currentTime = (int) logSee.getTime();
							
								//System.out.println("Parsing info for timestamp " + currentTime);
								parseSeeInfo(logSee, numRows, numCols);
								currentScene.setVision(logSee);
							}
						}
						
					}

					// actions
					// hard-coding it so that only 2 actions are stored
					else if (mytoken.equals("dash"))
					{
						Action newDash = new Action(Action.ACTION_DASH);
						m_tokenizer.nextToken(); // the ' '
						
						// also set angle, power and stuff!
						newDash.setActionPower(Float.valueOf(m_tokenizer.nextToken()).floatValue()); 
						
						m_tokenizer.nextToken(); // the ')'
							
						//if (currentScene.getActions().size() < 2)
						//{
							currentScene.addAction(newDash);
						//}
					}
					else if (mytoken.equals("turn"))
					{
						Action newTurn = new Action(Action.ACTION_TURN);
						m_tokenizer.nextToken(); // the ' '
						
						// also set angle, power and stuff!
						newTurn.setActionDirection(Float.valueOf(m_tokenizer.nextToken()).floatValue()); 
						
						m_tokenizer.nextToken(); // the ')'
							
						//if (currentScene.getActions().size() < 2)
						//{
							currentScene.addAction(newTurn);
						//}
					}
					else if (mytoken.equals("turn_neck"))
					{
						Action newTurn = new Action(Action.ACTION_TURNNECK);
						m_tokenizer.nextToken(); // the ' '
						
						// also set angle, power and stuff!
						newTurn.setActionDirection(Float.valueOf(m_tokenizer.nextToken()).floatValue()); 
						
						m_tokenizer.nextToken(); // the ')'
							
						//if (currentScene.getActions().size() < 2)
						//{
							currentScene.addAction(newTurn);
						//}
					}
					else if (mytoken.equals("kick"))
					{
						Action newKick = new Action(Action.ACTION_KICK);
						m_tokenizer.nextToken(); // the ' '
						
						// also set angle, power and stuff!
						newKick.setActionPower(Float.valueOf(m_tokenizer.nextToken()).floatValue()); 
						
						m_tokenizer.nextToken(); // the ' '
						
						newKick.setActionDirection(Float.valueOf(m_tokenizer.nextToken()).floatValue());
						 
						m_tokenizer.nextToken(); // the ')'
							
						//if (currentScene.getActions().size() < 2)
						//{
							currentScene.addAction(newKick);
						//}
					}
					else if (mytoken.equals("catch"))
					{
						//if (currentScene.getActions().size() < 2)
						//{

						currentScene.addAction(new Action(Action.ACTION_CATCH));
						// also set angle, power and stuff!
						//}
					}

					// otherwise ignore it, we don't care right now
				}
			}
			// is currentSlice = 6000 now, and not added?
			scenes.add(currentScene);

			in.close();
			
			// finished reading file and building objects... 
			pruneScenes();
			
			guessTargets();
			
			System.out.println(getPrunedSceneCount() + " scenes were pruned.");
			System.out.println("Done (read " + linecount + " lines).\n");
		}
		catch (Exception e) {

		}
	}
	
	/**
	 *  return an array of objectinfos, containing most likely target objects for action
	 */
	public static Vector predictTargets(Scene thisScene, Action thisAction, int confidence)
	{
		Vector likelyObjs = new Vector();
		
		double dir = thisAction.getActionDirection();
		
		Iterator objs = thisScene.getAllObjects().iterator();
		while (objs.hasNext())
		{
			// scan objects in the scene, look for matching directions
			ObjectInfo thisObject = (ObjectInfo) objs.next();
			double thisDir = thisObject.getDirection();
			if (Math.abs(thisDir - dir) <= confidence)
			{
				// directions are very similar, could be a match
				likelyObjs.add(thisObject);
			}
		}					
		
		return likelyObjs;
	}
	
	/**
	 * 
	 */
	private void guessTargets()
	{
		Iterator it = scenes.iterator();
		while (it.hasNext())
		{
			Scene thisScene = (Scene) it.next();
			
			// go through all the actions in this scene
			//System.out.println("Scene " + thisScene.getIdentString() + " action analysis:");
			Iterator acts = thisScene.getActions().iterator();
			while (acts.hasNext())
			{
				Action thisAction = (Action) acts.next();
				double dir = thisAction.getActionDirection();
				//System.out.println("  action " + thisAction + " in direction " + dir + " power " + thisAction.getActionPower());
				//System.out.println("  possible targets:");
				
				Vector simObjs = new Vector();
				
				Iterator objs = thisScene.getAllObjects().iterator();
				while (objs.hasNext())
				{
					// scan objects in the scene, look for matching directions
					ObjectInfo thisObject = (ObjectInfo) objs.next();
					double thisDir = thisObject.getDirection();
					if (Math.abs(thisDir - dir) < 2)
					{
						// directions are very similar, could be a match
						simObjs.add(thisObject);
						//System.out.println("  " + thisObject.getType() + ", dir "+ thisDir + " distance " + thisObject.getDistance());
					}
				}
				
				
			}

		}		
	}

	/**
	 * 
	 */
	private void pruneScenes()
	{
		int count = 0;
		
		System.out.print("Pruning scenes with no actions or visuals...");
		
		// iterate through the scenes, remove any empty or meaningless scenes
		Iterator it = scenes.iterator();
		while (it.hasNext())
		{
			Scene thisScene = (Scene) it.next();
			if (thisScene.getActions().size() == 0)
			{
				//System.out.println("Removing scene with no actions " + thisScene.getIdentString());
				it.remove();
				count++;
			}
			else if (thisScene.getAllObjects().size() == 0)
			{
				//System.out.println("Removing scene with no objects " + thisScene.getIdentString());
				it.remove();
				count++;
			}
		}								

		prunedScenesCount = count;
		
		System.out.println(count + " scenes removed.");
	}

	/**
	 * ParseSeeInfo -- iterate through a VisualInfo object; translate physical coordinates into cells/cols
	 * 
	 * This method is static because it is called upon by the modified Krislet brain to do this in real-time during a game
	 * Should maybe eventually move this to an external SceneGeneration object
	 * 
	 * @param vt
	 * @param logSee
	 */
	public static void parseSeeInfo(VisualInfo logSee, int numRows, int numCols)
	{
		placeObjects(logSee.getPlayerList(), numRows, numCols);
		placeObjects(logSee.getFlagList(), numRows, numCols);
		placeObjects(logSee.getGoalList(), numRows, numCols);
		placeObjects(logSee.getLineList(), numRows, numCols);
		placeObjects(logSee.getBallList(), numRows, numCols);
		
		if (logSee.getBallList() == null) {
			logSee.setSceneDist(0.0f);
		} else {
			ArrayList tmplst = logSee.getBallList();
			if (tmplst.size() > 0) {
				BallInfo tmpinfo = (BallInfo)tmplst.get(0);
				logSee.setSceneDist(tmpinfo.m_distance);
			} else {
				logSee.setSceneDist(0.0f);
			}
			
		}
	}
	
	
	// this function iterates through all ObjectInfo's in the list, adding row/col data to each
	private static void placeObjects(ArrayList objectList, int numRows, int numCols)
	{
		for (int i = 0; i < objectList.size(); i++)
		{
			ObjectInfo x = (ObjectInfo) objectList.get(i);
			
			// calculate which cell this object belongs to
			int cellx = whichslice(x.m_direction, numCols);
			int celly = whichdistance(x.m_distance, numRows);

			x.setTableColumn(cellx);
			x.setTableRow(celly);
		}
	}

	void writeScenes()
	{
		try
		{
			FileOutputStream fileOut = new FileOutputStream(sceneFileName + ".text");
			OutputStreamWriter outWriter =
				new OutputStreamWriter(fileOut, "US-ASCII");
			// throws exception
			PrintWriter out = new PrintWriter(outWriter); // throws exception
			
			System.out.println("Writing Scene Pictures file to " + sceneFileName + ".text");
			out.println("% Robocup Scene pictures generated by LogToScene.java");
			out.println("% Using rowsize=" + numRows + ", colsize=" + numCols);
			// iterate through objects here
			Iterator it = scenes.iterator();
			while (it.hasNext())
			{
				Scene thisScene = (Scene) it.next();

				out.println("Scene " + thisScene.getIdentString());
				out.println("Team " + thisScene.getTeamName());
				try {
				  out.println("# of Teammates/Oppos/Unknown = " + thisScene.getVision().getTeammatesList().size() + "/"
				  												+ thisScene.getVision().getOpponentsList().size() + "/"
																+ thisScene.getVision().getUnknownPlayersList().size());
				} catch(NullPointerException e) {}
				out.println("  table:\n" + thisScene.outputTable());
				out.println("  action:" + thisScene.getActions());
				Iterator actionIt = thisScene.getActions().iterator();
				while(actionIt.hasNext()) {
				  Action action = (Action) actionIt.next();
				  out.println("  actionDirection: " + action.getActionDirection() + "  actionPower: " + action.getActionPower());
				}
				out.println();
			}								

			// end of human-readable format...
			out.close();
			outWriter.close(); // throws exception
			fileOut.close();
			
			System.out.println("Writing Scene Store file to " + sceneFileName + ".scene");
			
			fileOut = new FileOutputStream(sceneFileName + ".scene");
			
			// future work: XML file?
			
			ObjectOutputStream oos = new ObjectOutputStream(fileOut);
			      oos.writeObject(new Integer(numRows));
			      oos.writeObject(new Integer(numCols));
				  oos.writeObject(scenes);
				  oos.close();
			fileOut.close();
			
		}
		catch (FileNotFoundException e)
		{

			e.printStackTrace();
		}
		catch (UnsupportedEncodingException e)
		{

			e.printStackTrace();
		}
		catch (IOException e)
		{

			e.printStackTrace();
		}
		
		System.out.println("Wrote " + scenes.size() + " scenes.");
		
	}

	/**
	 * Figure out which slice the given direction falls in
	 * next step: configurable number of slices
	 * @param f 	the distance
	 * @param numRows	the number of rows to use
	 * @return the distance slice to use
	 */
	private static int whichdistance(float f, int numRows)
	{
		// hard-coded to 3 for now; eventually will use numRows
		// we stick with 3 for now because that makes sense according to the server's own rules
		
		if (numRows != 3)
		{
			System.err.println("This version hard-codes the number of rows to 3.");
		}
		
		int distance = 0;
		
		// distance 0 is for objects less than 1 meter away
		// distance 1 is for objects 1-5 meters away
		// distance 2 is for everything past 5 meters
		if(f <= 1.4) return 0;
		else if ( (f >1.4 ) && (f<=5.0) ) return 1;
		else return 2;
	}

	/**
	 * Figure out which slice the given direction falls in
	 * slice formula: slice = (f + 180) / (360 / numslices)
	 * @param f the raw angle
	 * @param numslices the number of slices we want
	 * @return the slice number
	 */
	private static int whichslice(float f, int numslices)
	{
		if ( (f < -180.0) || (f > 180.0) )
		{
			System.err.println("Error!  Invalid angle!");
			return -1;
		}	
		if ( (numslices < 1) || (numslices > 360) )
		{
			System.err.println("Error!  Invalid slice number!");
			return -1;
		}	
		
		return (int)((f + 180.0) / (360 / numslices));
		
	}
	
	public int getPrunedSceneCount () {
		return prunedScenesCount;
	}
}
