/*
 * Created on Aug 10, 2004
 *
 * This is a simple nearest-neighbor distance-calculation algorithm and a trivial improvement over SimpleBallDistance.
 * The change here is simply to the implementation of findClosest, which now returns an array of "k" closest scenes.
 * 
 */
package visiontable;

import sceneInfo.ObjectInfo;
import sceneInfo.Scene;

/**
 * @author Kevin Lam
 *
 */
public class NearestNeighborBallDistance extends NearestNeighborParent
{
	int kValue = 1;
	
	/**
	 * 
	 */
	public NearestNeighborBallDistance(int k, char side)
	{
		super(k, side);
	}

	/* (non-Javadoc)
	 * @see visiontable.DistanceCalculation#distanceBetween(visiontable.VisionTable, visiontable.VisionTable)
	 */
	public float distanceBetween(Scene one, Scene two)
	{
		float dist1, dist2;
		
		// if either of the scenes has no ball, then distance is infinite
		// if both scenes have no ball, then it's a match
		if ( (one.getBallObjects().size() == 0) && (two.getBallObjects().size() == 0) )
		{
			return 0;
		}
		// one or the other, but not both...
		if ( (one.getBallObjects().size() == 0) || (two.getBallObjects().size() == 0) )
		{
			return 999;
		}

		// calculate the distance from me to the ball in object one, and two
		//ObjectInfo ballOne = (ObjectInfo) one.getBallObjects().elementAt(0);
		//ObjectInfo ballTwo = (ObjectInfo) two.getBallObjects().elementAt(0);
		ObjectInfo ballOne = (ObjectInfo) one.getBallObjects().get(0);
		ObjectInfo ballTwo = (ObjectInfo) two.getBallObjects().get(0);
		
		
		// and determine the distance between them
		
		return polarDistance(ballOne.m_distance, ballOne.m_direction, ballTwo.m_distance, ballTwo.m_direction);
	}

}
