/*
 * Created on Oct 28, 2004
 *
 * This is a simple implementation of a cartesian distance calculation involving all the objects in the scene
 * (lines, flags, players, goal, ball)
 * 
 * Note: this particular version does NOT determine what type an object is!  It simply considers what's closest!
 * not very logically valid; used only as a stepping stone for experimental results
 * 
 * Don't use me in the real world.
 * 
 */
package visiontable;

import java.util.*;

import sceneInfo.ObjectInfo;
import sceneInfo.Scene;

/**
 * @author kevlam
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class NearestNeighborCartesianAllObjects extends NearestNeighborParent
{

	/**
	 * @param k
	 */
	public NearestNeighborCartesianAllObjects(int k, char side)
	{
		super(k, side);
	}

	/* (non-Javadoc)
	 * @see visiontable.DistanceCalculation#distanceBetween(visiontable.VisionTable, visiontable.VisionTable)
	 */
	public float distanceBetween(Scene one, Scene two)
	{
		// maintain a list of all objects in each scene, sorted by their distance from me
		// then take sum of all distances between sets of objects
		Object[] sceneOneObjects = one.getAllObjects().toArray();
		int sceneOneSize = sceneOneObjects.length;
		sortObjectsByDistance(sceneOneObjects);
		
		Object[] sceneTwoObjects = two.getAllObjects().toArray();
		int sceneTwoSize = sceneTwoObjects.length;
		sortObjectsByDistance(sceneOneObjects);
		
		int smaller = (sceneOneSize < sceneTwoSize ? sceneOneSize :sceneTwoSize );
		int larger = (sceneOneSize > sceneTwoSize ? sceneOneSize :sceneTwoSize );
		
		float totalDist = 0;
		
		for (int i = 0; i < smaller; i++)
		{
			float r1 = ((ObjectInfo) sceneOneObjects[i]).getDistance();
			float th1 = ((ObjectInfo) sceneOneObjects[i]).getDirection();
			float r2 = ((ObjectInfo) sceneTwoObjects[i]).getDistance();
			float th2 = ((ObjectInfo) sceneTwoObjects[i]).getDirection();

			totalDist += polarDistance(r1, th1, r2, th2);
			
		}
		// assess penalty for all objects in one list but not in another?
		// penalty assessment should be weighted relative to some parameter like distance
		totalDist += (larger - smaller) * 100;
		
		return totalDist;
	}

	// sorts the array by the distance attribute in ObjectInfo
	public void sortObjectsByDistance(Object [] sceneObjects)
	{
		Arrays.sort(sceneObjects, new Comparator()
			{
				 public int compare(Object o1, Object o2)
				 {
					 float dist1 = ((ObjectInfo) o1).getDistance();
					 float dist2 = ((ObjectInfo) o2).getDistance();
  					 
					 if (dist1 == dist2)
						return 0;
					 else
						return (dist1 > dist2 ? 1 : -1);
				 }
			});
		
	}

}
