/*
 * Created on Feb 1, 2005
 *
 * This is a simple random distance calculator for experimental control purposes
 * 
 */
package visiontable;

import java.util.*;

import sceneInfo.Scene;

/**
 * @author Kevin Lam
 *
 */
public class RandomDistance extends NearestNeighborParent
{
	int kValue = 1;
	Random generator;
	
	/**
	 * 
	 */
	public RandomDistance(int k, char side)
	{
		super(k, side);
		
		generator = new Random();
	}

	public Scene[] findClosest(Scene key, List sceneSet)
	{
		
		Scene[] bestScenes = new Scene[kValue];
		Arrays.fill(bestScenes, null);

		int sceneSize = sceneSet.size();
		
		for (int i = 0; i < kValue; i++)
		{
			bestScenes[i] = (Scene) sceneSet.get(generator.nextInt(sceneSize));
		}
		
		return bestScenes;
		 
	}

}
